local info = debug.getinfo(1)
local source = info.source
local parts = string.split(source, "/")()

local libPrefix = table.concat(parts, "/", 1, 2)

return {
    __themeName = "MochaAurebesh",
    labelFontSize = 12,
    labelFilename = string.format([[%s/Aurebesh.ttf]], libPrefix),
    horizontalLine = {
        color = {0.3529, 0.2156, 0.1686, 1}
    },
    button = {
        disabledBG = {0.1, 0.08, 0.08, 0.3},
        disabledBorder = {0, 0, 0, 0, 1},
        disabledFG = {0, 0, 0, 0.7},
        hoveredBG = {0.6588, 0.4078, 0.2627, 0.9647},
        hoveredBorder = {0, 0, 0, 0, 1},
        hoveredFG = {0.9215, 0.8392, 0.7647, 1},
        normalBG = {0.5607, 0.3372, 0.2313, 0.9254},
        normalBorder = {0, 0, 0, 0, 1},
        normalFG = {0.9215, 0.8392, 0.7647, 1},
        pressedBG = {0.4, 0.1725, 0.2235, 0.9882},
        pressedBorder = {0, 0, 0, 0, 1},
        pressedFG = {0.9215, 0.8392, 0.7647, 1}
    },
    buttonClose = {
        hoveredBG = {0.85, 0.25, 0.25, 1},
        normalBG = {0.9, 0.1, 0.2, 0.3},
        pressedBG = {0.6, 0.08, 0.14, 1}
    },
    buttonGreen = {
        hoveredBG = {0.7, 0.9, 0.7, 0.9},
        normalBG = {0.5, 0.8, 0.5, 0.8},
        pressedBG = {0.5, 0.9, 0.5, 0.9}
    },
    default = {},
    dropdown = {},
    field = {
        disabledBG = {0.5, 0.5, 0.5, 0.7},
        disabledBorder = {0, 0, 0, 0.7, 1},
        disabledFG = {0, 0, 0, 0.7, 0},
        focusedBG = {1, 1, 1, 0.9},
        focusedBorder = {0, 0, 0, 0.9, 1},
        focusedFG = {0, 0, 0, 0.9, 1},
        normalBG = {0.95, 0.95, 0.95, 0.9},
        normalBorder = {0.08, 0.08, 0.08, 0.6, 1},
        normalFG = {0, 0, 0, 0.8, 0}
    },
    group = {
        bg = {},
        border = {},
        radius = 0
    },
    icon = {
        color = {0, 0, 0, 1}
    },
    image = {
        color = {1, 1, 1, 1}
    },
    label = {
        color = {0, 0, 0, 1}
    },
    list = {
        dragLineColor = {0.2, 0.2, 0.2, 1.0}
    },
    listItem = {
        disabledBG = {0.1, 0.08, 0.08, 0.5},
        disabledBorder = {0, 0, 0, 0, 1},
        disabledFG = {0, 0, 0, 0.7},
        hoveredBG = {0.6588, 0.4078, 0.2627, 0.9647},
        hoveredBorder = {0, 0, 0, 0, 1},
        hoveredFG = {0, 0, 0, 1},
        normalBG = {0.5607, 0.3372, 0.2313, 0.9254},
        normalBorder = {0, 0, 0, 0, 1},
        normalFG = {0, 0, 0, 1},
        pressedBG = {0.4, 0.1725, 0.2235, 0.9882},
        pressedBorder = {0, 0, 0, 0, 1},
        pressedFG = {0.9215, 0.8392, 0.7647, 1},
        radius = 0,
        selectedBG = {0.3529, 0.1686, 0.2156, 0.9411},
        selectedBorder = {0, 0, 0, 0, 1},
        selectedFG = {0.9215, 0.8392, 0.7647, 1}
    },
    listItemGreen = {
        hoveredBG = {0.7, 0.9, 0.7, 0.9},
        normalBG = {0.5, 0.8, 0.5, 0.8},
        pressedBG = {0.1, 0.6, 0.1, 0.9},
        selectedBG = {0.2, 0.7, 0.2, 0.9}
    },
    listItemYellow = {
        hoveredBG = {0.9, 0.8, 0.4, 0.9},
        normalBG = {0.8, 0.7, 0.3, 0.8},
        pressedBG = {0.3, 0.2, 0, 0.9},
        selectedBG = {0.4, 0.3, 0.1, 0.9}
    },
    menuItem = {
        bg = {0.08, 0.08, 0.08, 0.8}
    },
    menuItemSubmenu = {
        bg = {0.08, 0.08, 0.08, 0.8}
    },
    panel = {
        bg = {0.8784, 0.6901, 0.5098, 0.9019},
        border = {0, 0, 0, 0},
        radius = 3
    },
    scrollbox = {},
    scrollhandle = {
        border = {},
        color = {},
        hoveredBorder = {0.9215, 0.8392, 0.7647, 1, 1},
        hoveredColor = {0.9215, 0.8392, 0.7647, 1},
        normalBorder = {0.4, 0.1725, 0.2235, 0.9882, 1},
        normalColor = {0.8784, 0.6901, 0.5098, 0.9019},
        pressedBorder = {0.4, 0.1725, 0.2235, 0.9882, 1},
        pressedColor = {0.4, 0.1725, 0.2235, 0.9882},
        radius = 3,
        thickness = 6
    },
    scrollhandleX = {},
    scrollhandleY = {},
    spinner = {
        color = {0, 0, 0, 1}
    },
    titlebar = {
        border = {0, 0, 0, 0},
        focusedBG = {0.3529, 0.2156, 0.1686, 0.9647},
        focusedFG = {0.9215, 0.8392, 0.7647, 1},
        radius = 0,
        unfocusedBG = {0.3019, 0.2117, 0.1803, 0.88},
        unfocusedFG = {0.8784, 0.6901, 0.5098, 0.7}
    },
    topbar = {
        bg = {0.3529, 0.2156, 0.1686, 0.9647},
        radius = 0
    },
    window = {
        bg = {0.8784, 0.6901, 0.5098, 0.95},
        border = {0.3529, 0.1686, 0.2156, 0.9}
    }
}