
local info = debug.getinfo(1)
local source = info.source
local parts = string.split(source, "/")()

local libPrefix = table.concat(parts, "/", 1, 2)

return {
    __themeName = "TransSoft",
    labelFontSize = 12,
    labelFilename = string.format([[%s/RenogareSoft-Regular.ttf]], libPrefix),
    iconsPath = "ui/themes/light/icons/",
    horizontalLine = {
        color = {0.9215, 0.6745, 0.7803, 1.0}
    },
    button = {
        disabledBG = {0.4, 0.4, 0.4, 0.7},
        disabledBorder = {0, 0, 0, 0, 1},
        disabledFG = {0, 0, 0, 0.7},
        hoveredBG = {0.8745, 0.9294, 0.9294, 0.9},
        hoveredBorder = {0.5098, 0.9411, 0.9294, 0.9, 2},
        hoveredFG = {0, 0, 0, 1},
        normalBG = {0.9254, 0.8941, 0.9294, 0.9},
        normalBorder = {0.3960, 0.8588, 0.9019, 0.9, 2},
        normalFG = {0, 0, 0, 1},
        pressedBG = {0.5098, 0.9411, 0.9294, 1},
        pressedBorder = {0.5098, 0.9411, 0.9294, 1, 2},
        pressedFG = {0, 0, 0, 1},
    },
    buttonClose = {
        hoveredBG = {0.85, 0.25, 0.25, 1},
        normalBG = {0.92, 0.1, 0.1, 1},
        pressedBG = {0.65, 0.1, 0.15, 1}
    },
    buttonGreen = {
        hoveredBG = {0.7, 0.9, 0.7, 0.9},
        normalBG = {0.5, 0.8, 0.5, 0.8},
        pressedBG = {0.5, 0.9, 0.5, 0.9}
    },
    default = {},
    dropdown = {},
    field = {
        disabledBG = {0.5, 0.5, 0.5, 0.7},
        disabledBorder = {0, 0, 0, 0.7, 1},
        disabledFG = {0, 0, 0, 0.7, 0},
        focusedBG = {1, 1, 1, 0.9},
        focusedBorder = {0, 0, 0, 0.9, 1},
        focusedFG = {0, 0, 0, 0.9, 1},
        normalBG = {0.95, 0.95, 0.95, 0.9},
        normalBorder = {0.08, 0.08, 0.08, 0.6, 1},
        normalFG = {0, 0, 0, 0.8, 0}
    },
    group = {
        bg = {},
        border = {},
        radius = 0
    },
    icon = {
        color = {0, 0, 0, 1}
    },
    image = {
        color = {1, 1, 1, 1}
    },
    label = {
        color = {0, 0, 0, 1}
    },
    list = {
        dragLineColor = {0.2, 0.2, 0.2, 1.0}
    },
    listItem = {
        disabledBG = {0.4, 0.4, 0.4, 0.9},
        disabledBorder = {0, 0, 0, 0, 1},
        disabledFG = {0, 0, 0, 0.7},
        hoveredBG = {0.8745, 0.9294, 0.9294, 0.9},
        hoveredBorder = {0.5098, 0.9411, 0.9294, 0.9, 2},
        hoveredFG = {0, 0, 0, 1},
        normalBG = {0.9254, 0.8941, 0.9294, 0.9},
        normalBorder = {0.3960, 0.8588, 0.9019, 0.9, 2},
        normalFG = {0, 0, 0, 1},
        pressedBG = {0.5098, 0.9411, 0.9294, 1},
        pressedBorder = {0.5098, 0.9411, 0.9294, 1, 2},
        pressedFG = {0, 0, 0, 1},
        radius = 2,
        selectedBG = {0.9215, 0.6745, 0.7803, 1},
        selectedBorder = {0.9215, 0.6745, 0.7803, 1, 2},
        selectedFG = {0, 0, 0, 1}
    },
    listItemGreen = {
        hoveredBG = {0.7, 0.9, 0.7, 0.9},
        normalBG = {0.5, 0.8, 0.5, 0.8},
        pressedBG = {0.1, 0.6, 0.1, 0.9},
        selectedBG = {0.2, 0.7, 0.2, 0.9}
    },
    listItemYellow = {
        hoveredBG = {0.9, 0.8, 0.4, 0.9},
        normalBG = {0.8, 0.7, 0.3, 0.8},
        pressedBG = {0.3, 0.2, 0, 0.9},
        selectedBG = {0.4, 0.3, 0.1, 0.9}
    },
    menuItem = {
        bg = {0.08, 0.08, 0.08, 0.8}
    },
    menuItemSubmenu = {
        bg = {0.08, 0.08, 0.08, 0.8}
    },
    panel = {
        bg = {0.9254, 0.8941, 0.9294, 0.9},
        border = {0.9215, 0.6745, 0.7803, 0.9},
        radius = 3
    },
    scrollbox = {},
    scrollhandle = {
        border = {},
        color = {},
        hoveredBorder = {0.6, 0.6, 0.6, 0.7, 1},
        hoveredColor = {0.6, 0.6, 0.6, 1},
        normalBorder = {0.5, 0.5, 0.5, 1, 1},
        normalColor = {0.5, 0.5, 0.5, 0.6},
        pressedBorder = {0.55, 0.55, 0.55, 0.7, 1},
        pressedColor = {0.55, 0.55, 0.55, 1},
        radius = 3,
        thickness = 6
    },
    scrollhandleX = {},
    scrollhandleY = {},
    spinner = {
        color = {0, 0, 0, 1}
    },
    titlebar = {
        border = {0.3960, 0.8588, 0.9019, 0.9},
        focusedBG = {0.3960, 0.8588, 0.9019, 1},
        focusedFG = {0, 0, 0, 1},
        radius = 2,
        unfocusedBG = {0.2460, 0.7588, 0.8019, 0.85},
        unfocusedFG = {0.1, 0.1, 0.1, 0.7}
    },
    topbar = {
        bg = {0.3960, 0.8588, 0.9019, 0.8},
        radius = 2
    },
    window = {
        bg = {0.9254, 0.8941, 0.9294, 1},
        border = {0.3960, 0.8588, 0.9019, 1}
    }
}