local info = debug.getinfo(1)
local source = info.source
local parts = string.split(source, "/")()

local libPrefix = table.concat(parts, "/", 1, 2)
return {
    __themeName = "SmileOS",
    labelFontSize = 13,
    labelFilename = string.format([[%s/EpilepsySansSmile.ttf]], libPrefix),
    horizontalLine = {
        color = {0.3176, 0.0039, 0.0078, 0.8}
    },
    button = {
        disabledBG = {0.0862, 0.00392, 0.0, 0.9},
        disabledBorder = {0, 0, 0, 1},
        disabledFG = {0.7529, 0.0509, 0.0313, 1},
        hoveredBG = {0.2717, 0.2717, 0.2717, 1},
        hoveredBorder = {0, 0, 0, 1, 1},
        hoveredFG = {1, 1, 1, 1},
        normalBG = {0.3215, 0.3137, 0.3176, 1},
        normalBorder = {0, 0, 0, 1, 1},
        normalFG = {1, 1, 1, 1},
        pressedBG = {0.5882, 0.1176, 0.1137, 1},
        pressedBorder = {0, 0, 0, 1, 1},
        pressedFG = {0.74117, 0.2313, 0.2313, 1}
    },
    buttonClose = {
        hoveredBG = {0.3607, 0.1568, 0.0784, 0.9},
        normalBG = {0.8945, 0.1960, 0.2196, 0.5},
        pressedBG = {0.6, 0.08, 0.14, 1}
    },
    buttonGreen = {
        hoveredBG = {0.7, 0.9, 0.7, 0.9},
        normalBG = {0.5, 0.8, 0.5, 0.8},
        pressedBG = {0.5, 0.9, 0.5, 0.9}
    },
    default = {},
    dropdown = {},
    field = {
        disabledBG = {0.5, 0.5, 0.5, 0.7},
        disabledBorder = {0, 0, 0, 0.7, 1},
        disabledFG = {0, 0, 0, 0.7, 0},
        focusedBG = {1, 1, 1, 0.9},
        focusedBorder = {0, 0, 0, 0.9, 1},
        focusedFG = {0, 0, 0, 0.9, 1},
        normalBG = {0.95, 0.95, 0.95, 0.9},
        normalBorder = {0.08, 0.08, 0.08, 0.6, 1},
        normalFG = {0, 0, 0, 0.8, 0}
    },
    group = {
        bg = {},
        border = {},
        radius = 0
    },
    icon = {
        color = {1, 1, 1, 1}
    },
    image = {
        color = {1, 1, 1, 1}
    },
    label = {
        color = {1, 1, 1, 1}
    },
    list = {
        dragLineColor = {0.2, 0.2, 0.2, 1.0}
    },
    listItem = {
        disabledBG = {0.0862, 0.00392, 0.0, 0.9},
        disabledBorder = {0.052, 0.052, 0.052, 1, 1},
        disabledFG = {0.7529, 0.0509, 0.0313, 1},
        hoveredBG = {0.2717, 0.2717, 0.2717, 1},
        hoveredBorder = {0, 0, 0, 1, 1},
        hoveredFG = {1, 1, 1, 1},
        normalBG = {0.3215, 0.3137, 0.3176, 1},
        normalBorder = {0.052, 0.052, 0.052, 1, 1},
        normalFG = {1, 1, 1, 1},
        pressedBG = {0.5882, 0.1176, 0.1137, 1},
        pressedBorder = {0, 0, 0, 1, 1},
        pressedFG = {1, 1, 1, 1},
        radius = 3,
        selectedBG = {0.3176, 0.0039, 0.0078, 1},
        selectedBorder = {0, 0, 0, 1, 1},
        selectedFG = {1, 1, 1, 1}
    },
    listItemGreen = {
        hoveredBG = {0.7, 0.9, 0.7, 0.9},
        normalBG = {0.5, 0.8, 0.5, 0.8},
        pressedBG = {0.1, 0.6, 0.1, 0.9},
        selectedBG = {0.2, 0.7, 0.2, 0.9}
    },
    listItemYellow = {
        hoveredBG = {0.9, 0.8, 0.4, 0.9},
        normalBG = {0.8, 0.7, 0.3, 0.8},
        pressedBG = {0.3, 0.2, 0, 0.9},
        selectedBG = {0.4, 0.3, 0.1, 0.9}
    },
    menuItem = {
        bg = {0.08, 0.08, 0.08, 0.8}
    },
    menuItemSubmenu = {
        bg = {0.08, 0.08, 0.08, 0.8}
    },
    panel = {
        bg = {0.1747, 0.1747, 0.1747, 1},
        border = {0.0322, 0.0322, 0.0322, 1},
        radius = 0
    },
    scrollbox = {},
    scrollhandle = {
        border = {},
        color = {},
        hoveredBorder = {0.6, 0.6, 0.6, 0.7, 1},
        hoveredColor = {0.6, 0.6, 0.6, 1},
        normalBorder = {0.5, 0.5, 0.5, 1, 1},
        normalColor = {0.5, 0.5, 0.5, 0.6},
        pressedBorder = {0.55, 0.55, 0.55, 0.7, 1},
        pressedColor = {0.55, 0.55, 0.55, 1},
        radius = 3,
        thickness = 6
    },
    scrollhandleX = {},
    scrollhandleY = {},
    spinner = {
        color = {0, 0, 0, 1}
    },
    titlebar = {
        border = {0.3607, 0.3647, 0.3647, 0},
        focusedBG = {0.5882, 0.1176, 0.1137, 0.95},
        focusedFG = {1, 1, 1, 1},
        radius = 0,
        unfocusedBG = {0.5, 0.1, 0.1, 0.7},
        unfocusedFG = {0.95, 0.95, 0.95, 0.8}
    },
    topbar = {
        bg = {0.5882, 0.1176, 0.1137, 0.95},
        radius = 0
    },
    window = {
        bg = {0.1747, 0.1747, 0.1747, 1},
        border = {0.0322, 0.0322, 0.0322, 1}
    }
}