local vector2 = require("#microsoft.xna.framework.vector2")
local coroutineEntity = monocle.Entity()

function onBegin()
    waitUntilOnGround()
	player.ForceCameraUpdate = true
    disableRetry()
    disableMovement()
	playSound("event:/game/04_cliffside/gondola_finish")
	shake()
	walkTo(-632, false, 3.4, true)
	shake()
	engine.Scene:add(coroutineEntity)
	coroutineEntity:add(monocle.Coroutine(getLevel():ZoomTo(vector2(225, 90), 1.75, 1.25)))
	walkTo(-512, false, 6.1, true)
	shake()
	player.DummyAutoAnimate = false
	player.Sprite:Play("duck", true, false)
	walkTo(-450, false, 1, true)
	player.DummyAutoAnimate = true
	wait(0.6)
	celeste.Audio.SetMusicParam("dialog", 1.0)
    say("SJ2021_SOLOIINI_CONDUCTOR")
	coroutine.yield(getLevel():ZoomBack(0.5))
    end

function onEnd(level, wasSkipped)
	getLevel():remove(coroutineEntity)
    local luanet = _G.luanet 
    player.Facing = luanet.enum(luanet.import_type("Celeste.Facings"), "Right")
	celeste.Audio.SetMusicParam("dialog", 0.0)
    enableRetry()
    enableMovement()
	player.ForceCameraUpdate = false
	if wasSkipped then
		teleportTo(-452, 2192)
	end
end