-- ignore this, just getting VScode to shut up
---@diagnostic disable: undefined-global
---@diagnostic disable: lowercase-global

-- The IDs of the choicers we've gone through are stored here. Choosing a back option moves back one step, and if the stack is empty, it'll end the choicer.
choicer_stack = {}

-- Every choicer used in this cutscene. They MUST all be in this table, or else there may be issues with moving between them.
choicers = {
    choicer_intro = {
        {
            dialog = "ZESCENTHELPER_ChoicerIntroRead",
            page = "choicer_page1"
        },

        {
            dialog = "ZESCENTHELPER_ChoicerIntroDontRead",
            exit = true
        },

        {
            dialog = "ZESCENTHELPER_ChoicerIntroSecretOption",
            condition = function ()
                return math.random() > 0.5
            end,
            func = function ()
                die()
                wait(4)
            end,
        }
    },

    choicer_page1 = {
        {
            dialog = "ZESCENTHELPER_HowToStructure"
        },
        {
            dialog = "ZESCENTHELPER_ChoicerSettings",
            page = "choicer_settingspage"
        },
        {
            dialog = "ZESCENTHELPER_StopReading",
            say = false,
            exit = true
        }

    },

    choicer_settingspage = {
        {
            dialog = "ZESCENTHELPER_DialogSetting"
        },
        {
            dialog = "ZESCENTHELPER_SaySetting"
        },
        {
            dialog = "ZESCENTHELPER_PageSetting"
        },
        {
            dialog = "ZESCENTHELPER_NextPage",
            say = false,
            page = "choicer_settingspage2"
        },
        {
            dialog = "ZESCENTHELPER_Back",
            say = false,
            back = true
        },
        {
            dialog = "ZESCENTHELPER_StopReading",
            say = false,
            exit = true
        }

    },

    choicer_settingspage2 = {
        {
            dialog = "ZESCENTHELPER_PrevStackSetting"
        },
        {
            dialog = "ZESCENTHELPER_ConditionSetting"
        },
        {
            dialog = "ZESCENTHELPER_FuncSetting"
        },
        {
            dialog = "ZESCENTHELPER_NextPage",
            say = false,
            page = "choicer_settingspage3"
        },
        {
            dialog = "ZESCENTHELPER_LastPage",
            say = false,
            back = true
        },
        {
            dialog = "ZESCENTHELPER_StopReading",
            say = false,
            exit = true
        }
    },
    choicer_settingspage3 = {
        {
            dialog = "ZESCENTHELPER_BackSetting"
        },
        {
            dialog = "ZESCENTHELPER_ExitSetting"
        },
        {
            dialog = "ZESCENTHELPER_LastPage",
            say = false,
            back = true
        },
        {
            dialog = "ZESCENTHELPER_StopReading",
            say = false,
            exit = true
        }
    }
}


function onTalk()
    disableMovement()
    say("ZESCENTHELPER_ChoicerIntro")

    -- First argument is the name of your choicer table.
    -- Second is if this choicer should be added to the choicer tree. Defaults to true.
    choiceDialog(convertChoicer("choicer_intro", false))
end

function onEnd(room, wasSkipped)
    enableMovement()
end

function convertChoicer(choicer, add_stack) -- Converts a choicer skeleton into a table usable by the choiceDialog helper function.
    add_stack = add_stack ~= false
    local newchoicer = {}
    for i, choice in ipairs(choicers[choicer]) do 
        local prev_stack = choice.prev_stack ~= false
        newchoicer[i] = {
            choice.dialog,
            repeatable = true,
            requires = choice.condition,
            onChosen = function()
                if choice.say ~= false then say(choice.dialog .. "_say") end
                if choice.func then choice.func() end
                if choice.page then
                    if choice.say == false then wait(0.2) end
                    choiceDialog(convertChoicer(choice.page, prev_stack))
                end
                if choice.exit then closeChoiceDialog() end
                if choice.back and not choice.exit then
                    if choice.say == false then wait(0.2) end
                    table.remove(choicer_stack, #choicer_stack) -- Remove the end of the stack
                    if #choicer_stack <= 0 then
                        closeChoiceDialog()
                    else
                        choiceDialog(convertChoicer(choicer_stack[#choicer_stack], false)) -- Create whatever table is at the end of the stack
                    end
                end
            end
        }
    end
    if add_stack then table.insert(choicer_stack, choicer) end
    return newchoicer
end