--- Showing off callbacks available in the cutscene and brief explanations.
-- You are not required to define anything you aren't using.
-- Leave callbacks global to automatically detect it on c# side.
-- This assumes you know your way around Lua, if you don't then <a href=https://www.lua.org/pil/5.1.html>please consider reading the Lua PIL</a>.
-- <h2>Setting up in map editor</h2>
-- In the case of this cutscene, the filename for the entity field is "Assets/LuaCutscenes/example_cutscene".
-- Please use your own folders for your own cutscenes, like any other Celeste asset collisions can happen.<br>
-- <h2>Using C# in cutscene</h2>
-- Any imports from C# can be done with prefixing # in the require string. For example `local celeste = require("#Celeste")`.<br>
-- Check out helper_functions.lua for examples on C# interaction.
-- @module outside

local engine = require("#monocle.engine")
local monocle = require("#monocle")
local celeste = require("#celeste")

local function setLightingAlpha(n)
  engine.Scene.Lighting.Alpha = n + engine.Scene.BaseLightingAlpha
end

--- Coroutine that does all the cutscene magic.
-- This invloves stuff like walking, jumping, displaying text boxes, etc.
function onBegin()
	if not getFlag("outsideWatched") then
		player.ForceCameraUpdate = true
		disableMovement()
		helpers.walkTo(375)
		wait(0)
		coroutine.yield(getLevel():ZoomBack(0.6))
		player.DummyAutoAnimate = false
		coroutine.yield(player.Sprite:Play("idleA"))
		wait(0.4)
		helpers.say("SJ2021_1_PAINT_OUTSIDE")
		setFlag("outsideWatched", true)
		enableMovement()
	end
end

--- Callback for when the cutscene ends.
-- Function, no yielding actions allowed.
-- That means no walking, waiting etc.
-- Only "clean up" actions.
-- @tparam #Celeste.Level room Current room.
-- @bool wasSkipped If the cutscene was skipped.
function onEnd(room, wasSkipped)
    -- Skipping cutscenes is rude, you know :/
    if wasSkipped then
			enableMovement()
			setFlag("outsideWatched", true)
      coroutine.yield(getLevel():ZoomTo(vector2(164, 121), 2, 0))
      getLevel():remove(coroutineEntity)
    end
end