module ContortHelperAnxietyOriginController

using ..Ahorn, Maple

# Mapdef

@mapdef Entity "ContortHelper/AnxietyOriginController" AnxietyOriginController(
	x::Integer,
	y::Integer,

	origin::String="Player"
)

# Placements

const placements = Ahorn.PlacementDict(
	"Anxiety Origin Controller ($(origin)) (Contort Helper)" => Ahorn.EntityPlacement(
		AnxietyOriginController,
		"point",
		Dict{String,Any}(
			"origin" => origin
		)
	) for origin in Ahorn.ContortHelper.origintypes
)

# AnxietyOriginController

function Ahorn.selection(entity::AnxietyOriginController)
	nodes = get(entity.data, "nodes", ())
	x, y = Ahorn.position(entity)
	
	res = Ahorn.Rectangle[Ahorn.getSpriteRectangle(Ahorn.ContortHelper.anxietyorigincontroller, x, y)]
	
	for node in nodes
		nx, ny = Int.(node)
		push!(res, Ahorn.getSpriteRectangle(Ahorn.ContortHelper.anxietyorigincontroller, nx, ny))
	end

	return res
end

function Ahorn.renderSelectedAbs(ctx::Ahorn.Cairo.CairoContext, entity::AnxietyOriginController)
	px, py = Ahorn.position(entity)
	nodes = get(entity.data, "nodes", Tuple{Int, Int}[])

	for node in nodes
		nx, ny = Int.(node)

		Ahorn.drawArrow(ctx, px, py, nx, ny, Ahorn.colors.selection_selected_fc, headLength=6)
		Ahorn.drawSprite(ctx, Ahorn.ContortHelper.anxietyorigincontroller, nx, ny)
		px, py = nx, ny
	end
end

Ahorn.render(ctx::Ahorn.Cairo.CairoContext, entity::AnxietyOriginController, room::Maple.Room) = Ahorn.drawSprite(ctx, Ahorn.ContortHelper.anxietyorigincontroller, 0, 0)

Ahorn.editingOptions(entity::AnxietyOriginController) = Dict{String, Any}(
	"origin" => Ahorn.ContortHelper.origintypes
)

end