
module ContortHelperCustomEffectController

using ..Ahorn, Maple

# Mapdef

@mapdef Entity "ContortHelper/CustomEffectController" CustomEffectController(
	x::Integer,
	y::Integer,

	effect::String="",

	epileptic::Bool=false,
	shaky::Bool=false
)

# Placements

const placements = Ahorn.PlacementDict(
	"Custom Effect ($(name)) (Contort Helper)" => Ahorn.EntityPlacement(
		CustomEffectController,
		"point",
		Dict{String,Any}(
			"effect" => intl
		)
	) for (name, intl) in Ahorn.ContortHelper.effects
)

placements["Custom Effect (Unknown) (Contort Helper)"] = Ahorn.EntityPlacement(
	CustomEffectController,
	"rectangle"
)

# CustomEffectController

function Ahorn.selection(entity::CustomEffectController)
	nodes = get(entity.data, "nodes", ())
	x, y = Ahorn.position(entity)
	
	res = Ahorn.Rectangle[Ahorn.getSpriteRectangle(Ahorn.ContortHelper.customeffectcontroller, x, y)]
	
	for node in nodes
		nx, ny = Int.(node)
		push!(res, Ahorn.getSpriteRectangle(Ahorn.ContortHelper.customeffectcontroller, nx, ny))
	end

	return res
end

function Ahorn.renderSelectedAbs(ctx::Ahorn.Cairo.CairoContext, entity::CustomEffectController)
	px, py = Ahorn.position(entity)
	nodes = get(entity.data, "nodes", Tuple{Int, Int}[])

	for node in nodes
		nx, ny = Int.(node)

		Ahorn.drawArrow(ctx, px, py, nx, ny, Ahorn.colors.selection_selected_fc, headLength=6)
		Ahorn.drawSprite(ctx, Ahorn.ContortHelper.customeffectcontroller, nx, ny)
		px, py = nx, ny
	end
end

Ahorn.render(ctx::Ahorn.Cairo.CairoContext, entity::CustomEffectController, room::Maple.Room) = Ahorn.drawSprite(ctx, Ahorn.ContortHelper.customeffectcontroller, 0, 0)

Ahorn.editingOptions(entity::CustomEffectController) = Dict{String,Any}(
	"effect" => Ahorn.ContortHelper.effects
)

end