module ContortHelperFlickerLightSources

using ..Ahorn, Maple

# Mapdef

@mapdef Entity "ContortHelper/FlickerLightSource" FlickerLightSource(
	x::Integer,
	y::Integer,

	alpha::Number=1.0,
	radius::Number=48.0,

	startFade::Integer=24,
	endFade::Integer=48,

	color::String="White",
	durationOn::Number=1.0,
	durationOff::Number=1.0,
	startOn::String="True"
)

@mapdef Entity "ContortHelper/FlickerLightSourcePath" FlickerLightSourcePath(
	x::Integer,
	y::Integer,

	alpha::Number=1.0,
	radius::Number=48.0,

	startFade::Integer=24,
	endFade::Integer=48,

	color::String="White",
	durationOn::Number=1.0,
	durationOff::Number=1.0,
	startOn::String="True",

	moveSpeed::Number=1.181818,
	moveEaser::String="CubeInOut"
)

# Placements

const placements = Ahorn.PlacementDict()

for (name, startFade, endFade, radius) in Ahorn.ContortHelper.lightvariants
	placements["Flickering Light ($(name)) (Contort Helper)"] = Ahorn.EntityPlacement(
		FlickerLightSource,
		"point",
		Dict{String,Any}(
			"startFade" => startFade,
			"endFade" => endFade,
			"radius" => radius
		)
	)
	
	placements["Flickering Light ($(name), Path) (Contort Helper)"] = Ahorn.EntityPlacement(
		FlickerLightSourcePath,
		"point",
		Dict{String,Any}(
			"startFade" => startFade,
			"endFade" => endFade,
			"radius" => radius
		),
		function (entity)
			entity.data["nodes"] = [(Int(entity.data["x"]) + 16, Int(entity.data["y"]))]
		end
	)
end

# FlickerLightSource

function Ahorn.selection(entity::FlickerLightSource)
	nodes = get(entity.data, "nodes", ())
	x, y = Ahorn.position(entity)
	
	res = Ahorn.Rectangle[Ahorn.getSpriteRectangle(Ahorn.ContortHelper.flickerlightsource, x, y)]
	
	for node in nodes
		nx, ny = Int.(node)
		push!(res, Ahorn.getSpriteRectangle(Ahorn.ContortHelper.flickerlightsource, nx, ny))
	end

	return res
end

function Ahorn.renderSelectedAbs(ctx::Ahorn.Cairo.CairoContext, entity::FlickerLightSource)
	px, py = Ahorn.position(entity)
	nodes = get(entity.data, "nodes", Tuple{Int, Int}[])

	for node in nodes
		nx, ny = Int.(node)

		Ahorn.drawArrow(ctx, px, py, nx, ny, Ahorn.colors.selection_selected_fc, headLength=6)
		Ahorn.drawSprite(ctx, Ahorn.ContortHelper.flickerlightsource, nx, ny)
		px, py = nx, ny
	end
end

Ahorn.render(ctx::Ahorn.Cairo.CairoContext, entity::FlickerLightSource, room::Maple.Room) = Ahorn.drawSprite(ctx, Ahorn.ContortHelper.flickerlightsource, 0, 0)

Ahorn.editingOptions(entity::FlickerLightSource) = Dict{String, Any}(
	"color" => sort(collect(keys(Ahorn.XNAColors.colors))),
	"startOn" => Ahorn.ContortHelper.boolorrand
)

# FlickerLightSourcePath

Ahorn.nodeLimits(entity::FlickerLightSourcePath) = 1, 1

function Ahorn.selection(entity::FlickerLightSourcePath)
	nodes = get(entity.data, "nodes", ())
	x, y = Ahorn.position(entity)
	
	res = Ahorn.Rectangle[Ahorn.getSpriteRectangle(Ahorn.ContortHelper.flickerlightsourcepath, x, y)]
	
	for node in nodes
		nx, ny = Int.(node)
		push!(res, Ahorn.getSpriteRectangle(Ahorn.ContortHelper.flickerlightsourcepath, nx, ny))
	end

	return res
end

function Ahorn.renderSelectedAbs(ctx::Ahorn.Cairo.CairoContext, entity::FlickerLightSourcePath)
	px, py = Ahorn.position(entity)
	nodes = get(entity.data, "nodes", Tuple{Int, Int}[])

	for node in nodes
		nx, ny = Int.(node)

		Ahorn.drawArrow(ctx, px, py, nx, ny, Ahorn.colors.selection_selected_fc, headLength=6)
		Ahorn.drawSprite(ctx, Ahorn.ContortHelper.flickerlightsourcepath, nx, ny)
		px, py = nx, ny
	end
end

Ahorn.render(ctx::Ahorn.Cairo.CairoContext, entity::FlickerLightSourcePath, room::Maple.Room) = Ahorn.drawSprite(ctx, Ahorn.ContortHelper.flickerlightsourcepath, 0, 0)

Ahorn.editingOptions(entity::FlickerLightSourcePath) = Dict{String, Any}(
	"color" => sort(collect(keys(Ahorn.XNAColors.colors))),
	"moveEaser" => Ahorn.ContortHelper.easers,
	"startOn" => Ahorn.ContortHelper.boolorrand
)

end