module ContortHelperLightSources

using ..Ahorn, Maple

# Mapdef

@mapdef Entity "ContortHelper/LightSource" LightSource(
	x::Integer,
	y::Integer,

	alpha::Number=1.0,
	radius::Number=48.0,

	startFade::Integer=24,
	endFade::Integer=48,

	color::String="White"
)

@mapdef Entity "ContortHelper/LightSourcePath" LightSourcePath(
	x::Integer,
	y::Integer,

	alpha::Number=1.0,
	radius::Number=48.0,

	startFade::Integer=24,
	endFade::Integer=48,

	color::String="White",

	moveSpeed::Number=1.181818,
	moveEaser::String="CubeInOut"
)

# Placements

const placements = Ahorn.PlacementDict()

for (name, startFade, endFade, radius) in Ahorn.ContortHelper.lightvariants
	placements["Light ($(name)) (Contort Helper)"] = Ahorn.EntityPlacement(
		LightSource,
		"point",
		Dict{String,Any}(
			"startFade" => startFade,
			"endFade" => endFade,
			"radius" => radius
		)
	)
	
	placements["Light ($(name), Path) (Contort Helper)"] = Ahorn.EntityPlacement(
		LightSourcePath,
		"point",
		Dict{String,Any}(
			"startFade" => startFade,
			"endFade" => endFade,
			"radius" => radius
		),
		function (entity)
			entity.data["nodes"] = [(Int(entity.data["x"]) + 16, Int(entity.data["y"]))]
		end
	)
end

# LightSource

function Ahorn.selection(entity::LightSource)
	nodes = get(entity.data, "nodes", ())
	x, y = Ahorn.position(entity)
	
	res = Ahorn.Rectangle[Ahorn.getSpriteRectangle(Ahorn.ContortHelper.lightsource, x, y)]
	
	for node in nodes
		nx, ny = Int.(node)
		push!(res, Ahorn.getSpriteRectangle(Ahorn.ContortHelper.lightsource, nx, ny))
	end

	return res
end

function Ahorn.renderSelectedAbs(ctx::Ahorn.Cairo.CairoContext, entity::LightSource)
	px, py = Ahorn.position(entity)
	nodes = get(entity.data, "nodes", Tuple{Int, Int}[])

	for node in nodes
		nx, ny = Int.(node)

		Ahorn.drawArrow(ctx, px, py, nx, ny, Ahorn.colors.selection_selected_fc, headLength=6)
		Ahorn.drawSprite(ctx, Ahorn.ContortHelper.lightsource, nx, ny)
		px, py = nx, ny
	end
end

Ahorn.render(ctx::Ahorn.Cairo.CairoContext, entity::LightSource, room::Maple.Room) = Ahorn.drawSprite(ctx, Ahorn.ContortHelper.lightsource, 0, 0)

Ahorn.editingOptions(entity::LightSource) = Dict{String, Any}(
	"color" => sort(collect(keys(Ahorn.XNAColors.colors)))
)

# LightSourcePath

Ahorn.nodeLimits(entity::LightSourcePath) = 1, 1

function Ahorn.selection(entity::LightSourcePath)
	nodes = get(entity.data, "nodes", ())
	x, y = Ahorn.position(entity)
	
	res = Ahorn.Rectangle[Ahorn.getSpriteRectangle(Ahorn.ContortHelper.lightsourcepath, x, y)]
	
	for node in nodes
		nx, ny = Int.(node)
		push!(res, Ahorn.getSpriteRectangle(Ahorn.ContortHelper.lightsourcepath, nx, ny))
	end

	return res
end

function Ahorn.renderSelectedAbs(ctx::Ahorn.Cairo.CairoContext, entity::LightSourcePath)
	px, py = Ahorn.position(entity)
	nodes = get(entity.data, "nodes", Tuple{Int, Int}[])

	for node in nodes
		nx, ny = Int.(node)

		Ahorn.drawArrow(ctx, px, py, nx, ny, Ahorn.colors.selection_selected_fc, headLength=6)
		Ahorn.drawSprite(ctx, Ahorn.ContortHelper.lightsourcepath, nx, ny)
		px, py = nx, ny
	end
end

Ahorn.render(ctx::Ahorn.Cairo.CairoContext, entity::LightSourcePath, room::Maple.Room) = Ahorn.drawSprite(ctx, Ahorn.ContortHelper.lightsourcepath, 0, 0)

Ahorn.editingOptions(entity::LightSourcePath) = Dict{String, Any}(
	"color" => sort(collect(keys(Ahorn.XNAColors.colors))),
	"moveEaser" => Ahorn.ContortHelper.easers
)

end