module ContortHelper

using ..Ahorn, Maple

# Placements

const anxietyvariants = [
	("Light", 0.25),
	("Default", 0.8),
	("Heavy", 3.5)
]

const glitchvariants = [
	("Light", 0.1),
	("Default", 0.35),
	("Heavy", 0.8)
]

const burstattachervariants = [
	("Light", 1.0, 0.25, 25.0),
	("Default", 1.5, 0.25, 50.0),
	("Heavy", 2.0, 0.25, 100.0)
]

const bursteffectvariants = [
	("Light", 1.0, 0.25, 25.0),
	("Default", 1.5, 1.0, 50.0),
	("Heavy", 3.0, 1.0, 100.0)
]

const burstpathvariants = [
	("Light", 1.0, 20.0),
	("Default", 2.0, 50.0),
	("Heavy", 4.0, 125.0)
]

const burstzonevariants = [
	("Light", 1.0, 0.25, 10.0),
	("Default", 1.5, 0.01, 25.0),
	("Heavy", 2.0, 0.25, 150.0)
]

const lightvariants = [
	("Small", 10, 20, 20.0),
	("Default", 24, 48, 48.0),
	("Big", 60, 80, 80.0)
]

const madelinelightvariants = [
	("Small", 10, 20),
	("Default", 32, 64),
	("Big", 90, 110)
]

const alphalerplightsource = "ahorn/muntheory/contorthelper/alphalerplightsource.png"
const alphalerplightsourcepath = "ahorn/muntheory/contorthelper/alphalerplightsourcepath.png"

const anxietyeffectcontroller = "ahorn/muntheory/contorthelper/anxietyeffectcontroller.png"
const anxietyorigincontroller = "ahorn/muntheory/contorthelper/anxietyorigincontroller.png"

const bursteffect = "ahorn/muntheory/contorthelper/bursteffect.png"
const burstpath = "ahorn/muntheory/contorthelper/burstpath.png"
const burstcontroller = "ahorn/muntheory/contorthelper/burstcontroller.png"

const colorlerplightsource = "ahorn/muntheory/contorthelper/colorlerplightsource.png"
const colorlerplightsourcepath = "ahorn/muntheory/contorthelper/colorlerplightsourcepath.png"

const customeffectcontroller = "ahorn/muntheory/contorthelper/customeffectcontroller.png"

const flickerlightsource = "ahorn/muntheory/contorthelper/flickerlightsource.png"
const flickerlightsourcepath = "ahorn/muntheory/contorthelper/flickerlightsourcepath.png"

const glitcheffectcontroller = "ahorn/muntheory/contorthelper/glitcheffectcontroller.png"

const lightningstrikescontroller = "ahorn/muntheory/contorthelper/lightningstrikescontroller.png"

const lightsource = "ahorn/muntheory/contorthelper/lightsource.png"
const lightsourcepath = "ahorn/muntheory/contorthelper/lightsourcepath.png"

const teleportationtarget = "ahorn/muntheory/contorthelper/teleportationtarget.png"

const confettispawner = "ahorn/muntheory/contorthelper/confettispawner.png"
const confettispawnerpath = "ahorn/muntheory/contorthelper/confettispawnerpath.png"
const confetticontroller = "ahorn/muntheory/contorthelper/confetticontroller.png"

# Dictionaries

const effects = Dict{String,Any}(
	"Rainbow" => "muntheory/contorthelper/Rainbow.cso",
	"Light-Beams" => "muntheory/contorthelper/LightBeams.cso",
	"Multiverse" => "muntheory/contorthelper/Multiverse.cso"
)

const effects_boolparams = Dict{String,Any}(
	"Rainbow (Horizontal)" => "muntheory_contorthelper_rainbow_horizontal",

	"Light-Beams (Horizontal)" => "muntheory_contorthelper_lightbeams_horizontal",
)

const effects_intparams = Dict{String,Any}(
)

const effects_floatparams = Dict{String,Any}(
	"Rainbow (Speed)" => "muntheory_contorthelper_rainbow_speed",
	"Rainbow (Offset Multiplier)" => "muntheory_contorthelper_rainbow_offsetmulti",

	"Light-Beams (Speed)" => "muntheory_contorthelper_lightbeams_speed",
	"Light-Beams (Position Speed)" => "muntheory_contorthelper_lightbeams_positionspeed",
	"Light-Beams (Denominator Multiplier)" => "muntheory_contorthelper_lightbeams_denominatormulti",
	
	"Multiverse (Speed)" => "muntheory_contorthelper_multiverse_speed",
	"Multiverse (Duration)" => "muntheory_contorthelper_multiverse_duration",
	"Multiverse (Subtracter)" => "muntheory_contorthelper_multiverse_subtracter",
	"Multiverse (Denominator)" => "muntheory_contorthelper_multiverse_denominator"
)

const effects_strparams = Dict{String,Any}(
)

const effects_vec2params = Dict{String,Any}(
)

const effects_vec3params = Dict{String,Any}(
)

const effects_vec4params = Dict{String,Any}(
)

const effects_matrixparams = Dict{String,Any}(
)

const effects_quaternionparams = Dict{String,Any}(
)

const effects_colorparams = Dict{String,Any}(
)

const effects_boolarrparams = Dict{String,Any}(
)

const effects_intarrparams = Dict{String,Any}(
)

const effects_floatarrparams = Dict{String,Any}(
)

const operations = Dict{String,Any}(
	"=" => "Set",
	"+" => "Addition",
	"-" => "Subtraction",
	"*" => "Multiplication",
	"/" => "Division"
)

const conditionals = Dict{String,Any}(
	"<" => "LessThan",
	"<=" => "LessThanOrEqualTo",
	"==" => "EqualTo",
	">=" => "GreaterThanOrEqualTo",
	">" => "GreaterThan",
)

const easers = [

	# Defaults

	"Linear",

	"SineIn",
	"SineOut",
	"SineInOut",

	"QuadIn",
	"QuadOut",
	"QuadInOut",

	"CubeIn",
	"CubeOut",
	"CubeInOut",

	"QuintIn",
	"QuintOut",
	"QuintInOut",

	"ExpoIn",
	"ExpoOut",
	"ExpoInOut",

	"BackIn",
	"BackOut",
	"BackInOut",

	"BigBackIn",
	"BigBackOut",
	"BigBackInOut",

	"ElasticIn",
	"ElasticOut",
	"ElasticInOut",

	"BounceIn",
	"BounceOut",
	"BounceInOut",

	# Exclusive

	"HexIn",
	"HexOut",
	"HexInOut",

	"SeptIn",
	"SeptOut",
	"SeptInOut",

	"OctIn",
	"OctOut",
	"OctInOut",

	"NonIn",
	"NonOut",
	"NonInOut",

	"DecIn",
	"DecOut",
	"DecInOut",

	"Round"
]

const attaches = [
	"All",
	"Player",
	"Spikes",
	"ZipMover",
	"Refill",
	"Strawberry",
	"DreamBlock",
	"Chaser",
	"TouchSwitch",
	"TouchGate",
	"Key",
	"LockDoor",
	"Oshiro",
	"Spinner",
	"Cloud",
	"Booster",
	"MoveBlock",
	"Snowball",
	"Seeker",
	"SwapBlock",
	"TheoCrystal",
	"Torch",
	"CrushBlock",
	"Feather",
	"Boss",
	"BounceBlock",
	"Glider",
	"Puffer"
]

const attachesspecific = [
	
]

const origintypes = [
	"Player"
]

const rumblestrength = [
	"Climb",
	"Low",
	"Medium",
	"Strong"
]

const rumblelength = [
	"FullSecond",
	"TwoSeconds",
	"Short",
	"Medium",
	"Long"
]

const boolorrand = [
	"True",
	"False",
	"Random"
]

const facings = [
	"Left",
	"Right"
]

const depths = Dict{String,Any}(
	"BGTerrain" => +10000,
	"BGMirrors" => +9500,
	"BGDecals" => +9000,
	"BGParticles" => +8000,
	"SolidsBelow" => +5000,
	"Below" => +2000,
	"NPCs" => +1000,
	"TheoCrystal" => +100,
	"Player" => +0,
	"Dust" => -50,
	"Pickups" => -100,
	"Seeker" => -200,
	"Particles" => -8000,
	"Above" => -8500,
	"Solids" => -9000,
	"FGTerrain" => -10000,
	"FGDecals" => -10500,
	"DreamBlocks" => -11000,
	"CrystalSpinners" => -11500,
	"PlayerDreamDashing" => -12000,
	"Enemy" => -12500,
	"FakeWalls" => -13000,
	"FGParticles" => -50000,
	"Top" => -1000000,
	"FormationSequences" => -2000000
)

const player_states = Dict{String,Any}(
	"Normal" => 0,
	"Climb" => 1,
	"Dash" => 2,
	"Swim" => 3,
	"Boost" => 4,
	"RedDash" => 5,
	"HitSquash" => 6,
	"Launch" => 7,
	"Pickup" => 8,
	"DreamDash" => 9,
	"SummitLaunch" => 10,
	"Dummy" => 11,
	"IntroWalk" => 12,
	"IntroJump" => 13,
	"IntroRespawn" => 14,
	"IntroWakeUp" => 15,
	"BirdDashTutorial" => 16,
	"Frozen" => 17,
	"ReflectionFall" => 18,
	"StarFly" => 19,
	"TempleFall" => 20,
	"CassetteFly" => 21,
	"Attract" => 22,
	"IntroMoonJump" => 23,
	"FlingBird" => 24,
	"IntroThinkForABit" => 25
)

const dreamdirections = [
	"Up",
	"Down",
	"Left",
	"Right",
	"UpLeft",
	"UpRight",
	"DownLeft",
	"DownRight"
]

end