module ContortHelperBurstEffectTrigger

using ..Ahorn, Maple

# Mapdef

@mapdef Trigger "ContortHelper/BurstEffectTrigger" BurstEffectTrigger(
	x::Integer,
	y::Integer,
	width::Integer=Maple.defaultTriggerWidth,
	height::Integer=Maple.defaultTriggerHeight,

	texture::String="util/displacementcircle",

	burstDuration::Number=1.5,

	radiusFrom::Number=0.0,
	radiusTo::Number=50.0,

	alpha::Number=1.0,

	alphaEaser::String="CubeInOut",
	radiusEaser::String="CubeInOut",

	needed::Bool=false,

	neededFlags::String="",
	flagsAfterInvoke::String="",

	delay::Number=0.0,
	occurOnEnter::Bool=true,
	oneUse::Bool=false,
	persistent::Bool=false
)

# Placements

const placements = Ahorn.PlacementDict()

for (name, burstDuration, coroutineDuration, radiusTo) in Ahorn.ContortHelper.bursteffectvariants
	placements["Burst Trigger ($(name), Node) (Contort Helper)"] = Ahorn.EntityPlacement(
		BurstEffectTrigger,
		"rectangle",
		Dict{String,Any}(
			"burstDuration" => burstDuration,
			"radiusTo" => radiusTo
		),
		function (trigger)
			trigger.data["nodes"] = [(Int(trigger.data["x"]) + Int(trigger.data["width"]) + 8, Int(trigger.data["y"]))]
		end
	)
	
	placements["Burst Trigger ($(name), Player) (Contort Helper)"] = Ahorn.EntityPlacement(
		BurstEffectTrigger,
		"rectangle",
		Dict{String,Any}(
			"burstDuration" => burstDuration,
			"radiusTo" => radiusTo
		)
	)
end

# BurstEffectTrigger

Ahorn.nodeLimits(trigger::BurstEffectTrigger) = 0, 1

Ahorn.editingOptions(entity::BurstEffectTrigger) = Dict{String, Any}(
	"alphaEaser" => Ahorn.ContortHelper.easers,
	"radiusEaser" => Ahorn.ContortHelper.easers
)

end