module ContortHelperCustomEffectTrigger

using ..Ahorn, Maple

# Mapdef

@mapdef Trigger "ContortHelper/CustomEffectTrigger" CustomEffectTrigger(
	x::Integer,
	y::Integer,
	width::Integer=Maple.defaultTriggerWidth,
	height::Integer=Maple.defaultTriggerHeight,

	effect::String="",
	add::Bool=true,

	epileptic::Bool=false,
	shaky::Bool=false,

	neededFlags::String="",
	flagsAfterInvoke::String="",

	delay::Number=0.0,
	occurOnEnter::Bool=true,
	oneUse::Bool=false,
	persistent::Bool=false
)

@mapdef Trigger "ContortHelper/ClearCustomEffectsTrigger" ClearCustomEffectsTrigger(
	x::Integer,
	y::Integer,
	width::Integer=Maple.defaultTriggerWidth,
	height::Integer=Maple.defaultTriggerHeight,

	neededFlags::String="",
	flagsAfterInvoke::String="",

	delay::Number=0.0,
	occurOnEnter::Bool=true,
	oneUse::Bool=false,
	persistent::Bool=false
)

# Placements

const placements = Ahorn.PlacementDict(
	"Custom Effect Trigger ($(name)) (Contort Helper)" => Ahorn.EntityPlacement(
		CustomEffectTrigger,
		"rectangle",
		Dict{String,Any}(
			"effect" => intl
		)
	) for (name, intl) in Ahorn.ContortHelper.effects
)

placements["Custom Effect Trigger (Unknown) (Contort Helper)"] = Ahorn.EntityPlacement(
	CustomEffectTrigger,
	"rectangle"
)

placements["Custom Effect Trigger (Clear) (Contort Helper)"] = Ahorn.EntityPlacement(
	ClearCustomEffectsTrigger,
	"rectangle"
)

# CustomEffectTrigger

Ahorn.editingOptions(entity::CustomEffectTrigger) = Dict{String,Any}(
	"effect" => Ahorn.ContortHelper.effects
)

end