module ContortHelperFlashTrigger

using ..Ahorn, Maple

# Mapdef

@mapdef Trigger "ContortHelper/FlashTrigger" FlashTrigger(
	x::Integer,
	y::Integer,
	width::Integer=Maple.defaultTriggerWidth,
	height::Integer=Maple.defaultTriggerHeight,

	color::String="White",
	colorAlpha::Number=0.7,
	overPlayer::Bool=false,

	neededFlags::String="",
	flagsAfterInvoke::String="",

	delay::Number=0.0,
	occurOnEnter::Bool=true,
	oneUse::Bool=false,
	persistent::Bool=false,

	needed::Bool=false
)

# Placements

const placements = Ahorn.PlacementDict(
	"Flash Trigger $(needed ? "(Needed) " : "")(Contort Helper)" => Ahorn.EntityPlacement(
		FlashTrigger,
		"rectangle",
		Dict{String,Any}(
			"needed" => needed
		)
	) for needed in [true, false]
)

# FlashTrigger

Ahorn.editingOptions(entity::FlashTrigger) = Dict{String,Any}(
	"color" => sort(collect(keys(Ahorn.XNAColors.colors)))
)

end