module ContortHelperGlitchEffectTrigger

using ..Ahorn, Maple

# Mapdef

@mapdef Trigger "ContortHelper/GlitchEffectTrigger" GlitchEffectTrigger(
	x::Integer,
	y::Integer,
	width::Integer=Maple.defaultTriggerWidth,
	height::Integer=Maple.defaultTriggerHeight,

	position::String="NoEffect",
	from::Number=0.0,
	to::Number=0.3,

	oneUse::Bool=false,
	persistent::Bool=false
)

# Placements

const placements = Ahorn.PlacementDict(
	"Glitch Effect Trigger ($(name)) (Contort Helper)" => Ahorn.EntityPlacement(
		GlitchEffectTrigger,
		"rectangle",
		Dict{String,Any}(
			"to" => enterValue
		)
	) for (name, enterValue) in Ahorn.ContortHelper.glitchvariants
)

# GlitchEffectTrigger

Ahorn.editingOptions(entity::GlitchEffectTrigger) = Dict{String,Any}(
	"position" => Maple.trigger_position_modes
)

end