module ContortHelperRumbleTrigger

using ..Ahorn, Maple

# Mapdef

@mapdef Trigger "ContortHelper/RumbleTrigger" RumbleTrigger(
	x::Integer,
	y::Integer,
	width::Integer=Maple.defaultTriggerWidth,
	height::Integer=Maple.defaultTriggerHeight,

	rumbleStrength::String="Low",
	rumbleLength::String="Short",

	specificStrength::Number=0.0,
	specificLength::Number=0.0,

	neededFlags::String="",
	flagsAfterInvoke::String="",

	delay::Number=0.0,
	occurOnEnter::Bool=true,
	oneUse::Bool=false,
	persistent::Bool=false,

	needed::Bool=false
)

# Placements

const placements = Ahorn.PlacementDict(
	"Rumble Trigger $(needed ? "(Needed) " : "")(Contort Helper)" => Ahorn.EntityPlacement(
		RumbleTrigger,
		"rectangle",
		Dict{String,Any}(
			"needed" => needed
		)
	) for needed in [true, false]
)

# RumbleTrigger

Ahorn.editingOptions(entity::RumbleTrigger) = Dict{String,Any}(
	"rumbleStrength" => ContortHelper.rumblestrength,
	"rumbleLength" => ContortHelper.rumblelength
)

end