module ContortHelperShakeTrigger

using ..Ahorn, Maple

@mapdef Trigger "ContortHelper/ShakeTrigger" ShakeTrigger(
	x::Integer,
	y::Integer,
	width::Integer=Maple.defaultTriggerWidth,
	height::Integer=Maple.defaultTriggerHeight,

	directionX::Number=1.0,
	directionY::Number=1.0,
	screenShake::Number=0.3,
	
	directional::Bool=false,
	stopShake::Bool=false,

	neededFlags::String="",
	flagsAfterInvoke::String="",

	delay::Number=0.0,
	occurOnEnter::Bool=true,
	oneUse::Bool=false,
	persistent::Bool=false,

	needed::Bool=false
)

const placements = Ahorn.PlacementDict(
	"Shake Trigger $(needed ? "(Needed) " : "")(Contort Helper)" => Ahorn.EntityPlacement(
		ShakeTrigger,
		"rectangle",
		Dict{String,Any}(
			"needed" => needed
		)
	) for needed in [true, false]
)

placements["Shake Trigger (Stops) (Contort Helper)"] = Ahorn.EntityPlacement(
	ShakeTrigger,
	"rectangle",
	Dict{String,Any}(
		"stopShake" => true
	)
)

end