module SpirialisBoostPad

using ..Ahorn, Maple

@mapdef Entity "spirialis/boostpad" BoostPad(x::Integer, y::Integer, width::Integer=16, height::Integer=8, direction::Integer=0, speed::Number=250.0)

const placements = Ahorn.PlacementDict(
	"Boostpad (Spirialis)" => Ahorn.EntityPlacement(
		BoostPad,
		"rectangle"
	)
)

Ahorn.editingOptions(entity::BoostPad) = Dict{String, Any}(
	"direction" => Dict{String, Int}(
		"Right" => 0,
		"Left" => 1,
		"Up" => 2,
		"Down" => 3
	)
)

Ahorn.minimumSize(entity::BoostPad) = 8, 8
Ahorn.resizable(entity::BoostPad) = true, true
Ahorn.selection(entity::BoostPad) = Ahorn.getEntityRectangle(entity)

const texture1 = "objects/spirialis/boostpad/boostpad1"
const texture2 = "objects/spirialis/boostpad/boostpad2"
const texture3 = "objects/spirialis/boostpad/boostpad3"

function drawBoostPad(ctx::Ahorn.Cairo.CairoContext, entity::BoostPad, room::Maple.Room)
	x, y = Ahorn.position(entity)
	width = Int(get(entity.data, "width", 32))
	height = Int(get(entity.data, "height", 16))
	tileWidth = ceil(Int, width / 8)
	tileHeight = ceil(Int, height / 8)
	direction = Int(get(entity.data, "direction", 0))
	
	if direction == 0
		t1, t2 = texture2, texture1
	elseif direction == 1
		t1, t2 = texture1, texture2
	elseif direction == 2
		t1, t2 = texture1, texture3
	elseif direction == 3
		t1, t2 = texture3, texture1
	end
	
	if (direction <= 1)
		for x in 1:tileWidth
			if (tileHeight % 2 == 1)
				Ahorn.drawImage(ctx, t1, (x - 1) * 8, 0, 0, 4, 8, 4)
				Ahorn.drawImage(ctx, t2, (x - 1) * 8, tileHeight * 8 - 4, 0, 0, 8, 4)
			end
			for y in 1:floor(Int, tileHeight / 2)
				Ahorn.drawImage(ctx, t1, (x - 1) * 8, (tileHeight / 2.0 - y) * 8)
				Ahorn.drawImage(ctx, t2, (x - 1) * 8, (tileHeight / 2.0 + (y - 1)) * 8)
			end
		end
	else
		for y in 1:tileHeight
			if (tileWidth % 2 == 1)
				Ahorn.drawImage(ctx, t1, 0, (y - 1) * 8, 4, 0, 4, 8)
				Ahorn.drawImage(ctx, t2, tileWidth * 8 - 4, (y - 1) * 8, 0, 0, 4, 8)
			end
			for x in 1:floor(Int, tileWidth / 2)
				Ahorn.drawImage(ctx, t1, (tileWidth / 2.0 - x) * 8, (y - 1) * 8)
				Ahorn.drawImage(ctx, t2, (tileWidth / 2.0 + (x - 1)) * 8, (y - 1) * 8)
			end
		end
	end
end

Ahorn.render(ctx::Ahorn.Cairo.CairoContext, entity::BoostPad, room::Maple.Room) = drawBoostPad(ctx, entity, room)

end