module SpirialisWaterFloatingObject

using ..Ahorn, Maple

@mapdef Entity "spirialis/waterfloatingobject" WaterFloatingObject(x::Integer, y::Integer, texture::String="objects/spirialis/lilypad_a", verticalOffset::Number=1.0, oscillationAmplitude::Number=5.0, oscillationPeriod::Number=25.0, mass::Number=7.0, depth::Integer=100, allowRotation::Bool=true, lightSource::Bool=false, flipHorizontal::Bool=false)

const placements = Ahorn.PlacementDict(
	"Water Floating Object (Spirialis)" => Ahorn.EntityPlacement(
	WaterFloatingObject,"point",
		Dict{String, Any}()
	)
)

function Ahorn.selection(entity::WaterFloatingObject)
	x, y = Ahorn.position(entity)
	return Ahorn.getSpriteRectangle(get(entity.data, "texture", "objects/spirialis/lilypad_a"), x, y)
end

function Ahorn.render(ctx::Ahorn.Cairo.CairoContext, entity::WaterFloatingObject, room::Maple.Room)
	Ahorn.drawSprite(ctx, get(entity.data, "texture", "objects/spirialis/lilypad_a"), 0, 0)
end

end