﻿module MaxHelpingHandTempleEyeTrackingMadeline

using ..Ahorn, Maple

@mapdef Entity "MaxHelpingHand/TempleEyeTrackingMadeline" TempleEyeTrackingMadeline(x::Integer, y::Integer, spriteDirectory::String="scenery/temple/eye")

const placements = Ahorn.PlacementDict(
    "Temple Eye (Small, Follow Madeline) (Maddie's Helping Hand)" => Ahorn.EntityPlacement(
        TempleEyeTrackingMadeline
    )
)

function Ahorn.selection(entity::TempleEyeTrackingMadeline)
    x, y = Ahorn.position(entity)

    return Ahorn.Rectangle(x - 6, y - 6, 12, 12)
end

function Ahorn.render(ctx::Ahorn.Cairo.CairoContext, entity::TempleEyeTrackingMadeline, room::Maple.Room)
    x, y = Ahorn.position(entity)
    tx, ty = floor(Int, x / 8) + 1, floor(Int, y / 8) + 1

    layer = get(room.fgTiles.data, (ty, tx), '0') == '0' ? "bg" : "fg"

    spriteDirectory = get(entity, "spriteDirectory", "scenery/temple/eye")

    Ahorn.drawSprite(ctx, "$(spriteDirectory)/$(layer)_eye.png", 0, 0)
    Ahorn.drawSprite(ctx, "$(spriteDirectory)/$(layer)_lid00.png", 0, 0)
    Ahorn.drawSprite(ctx, "$(spriteDirectory)/$(layer)_pupil.png", 0, 0)
end

end
