module JackalHelperBotBox

using ..Ahorn, Maple

@mapdef Entity "JackalHelper/BotBox" BotBox(x::Integer, y::Integer)


const placements = Ahorn.PlacementDict(
    "Bot Box (Jackal Helper)" => Ahorn.EntityPlacement(
        BotBox,
        "point",
    )
)


sprite = "characters/theoCrystal/idle00"


function Ahorn.selection(entity::BotBox)
    x, y = Ahorn.position(entity)
    return Ahorn.getSpriteRectangle(sprite, x, y)
end

Ahorn.render(ctx::Ahorn.Cairo.CairoContext, entity::BotBox, room::Maple.Room) = Ahorn.drawSprite(ctx, sprite, 0, 0)

end