module JackalHelperInsightCrystal

using ..Ahorn, Maple

@mapdef Entity "JackalHelper/InsightCrystal" InsightCrystal(x::Integer, y::Integer)

const placements = Ahorn.PlacementDict(
    "Insight Crystal (Jackal Helper)" => Ahorn.EntityPlacement(
        InsightCrystal,
        "point",
    )
)

function torchSprite(entity::InsightCrystal)
    return "objects/temple/torch03.png"
end

function Ahorn.selection(entity::InsightCrystal)
    x, y = Ahorn.position(entity)
    sprite = torchSprite(entity)

    return Ahorn.getSpriteRectangle(sprite, x, y)
end

function Ahorn.render(ctx::Ahorn.Cairo.CairoContext, entity::InsightCrystal, room::Maple.Room)
    sprite = torchSprite(entity)
    Ahorn.drawSprite(ctx, sprite, 0, 0)
end

end