module JackalHelperCoreBooster

using ..Ahorn, Maple

@mapdef Entity "JackalCollabHelper/CoreBooster" CoreBooster(x::Integer, y::Integer, startHot::bool=true)


const placements = Ahorn.PlacementDict(
   "Core Booster (Jackal Collab Helper)" => Ahorn.EntityPlacement(
	  CoreBooster,
	  "point"
   )
)

sprite = "objects/booster/booster00"

function Ahorn.selection(entity::CoreBooster)
    x, y = Ahorn.position(entity)
    return Ahorn.getSpriteRectangle(sprite, x, y)
end

Ahorn.render(ctx::Ahorn.Cairo.CairoContext, entity::CoreBooster, room::Maple.Room) = Ahorn.drawSprite(ctx, sprite, 0, 0)

end