module JackalCollabHelperDarkMatterController
using ..Ahorn, Maple

@mapdef Entity "JackalCollabHelper/DarkMatterController" DarkMatterController(x::Integer, y::Integer, acceleration::Number=0.6, finalMultiplier::Number=4.0, particleDensity::Number=96.0, baseColor1::String="3b0c1c", baseColor2::String="3b0c2c", baseColor3::String="3b0c3c", baseColor4::String="3b0c4c", baseColor5::String="3b0c5c", baseColor6::String="3b0c1c", edgeColor1::String="5e0824", edgeColor2::String="5e0834", edgeColor3::String="5e0844", edgeColor4::String="5e0854", edgeColor5::String="5e0864", edgeColor6::String="5e0874", flipX::Bool=false, flipY::Bool=false)

const placements = Ahorn.PlacementDict(
   "Dark Matter Controller (Jackal Collab Helper)" => Ahorn.EntityPlacement(
        DarkMatterController, 
        "point")
)


const sprite = "objects/booster/boosterRed00.png"

function getSprite(entity::DarkMatterController)
    return sprite
end

function Ahorn.selection(entity::DarkMatterController)
    x, y = Ahorn.position(entity)
    sprite = getSprite(entity)

    return Ahorn.getSpriteRectangle(sprite, x, y)
end

function Ahorn.render(ctx::Ahorn.Cairo.CairoContext, entity::DarkMatterController, room::Maple.Room)
    sprite = getSprite(entity)
    Ahorn.drawSprite(ctx, sprite, 0, 0)
end

end
