module JackalCollabHelperDeepSpaceModule

using ..Ahorn, Maple

@mapdef Entity "JackalCollabHelper/DarkMatter" DeepSpace(x::Integer, y::Integer, width::Integer=8, height::Integer=8, zapTop::Bool=false, zapBottom::Bool=false, zapLeft::Bool=false, zapRight::Bool=false)


const placements = Ahorn.PlacementDict(
    "Dark Matter (Jackal Collab Helper)" => Ahorn.EntityPlacement(
        DeepSpace,
        "rectangle"
    )
)

Ahorn.minimumSize(entity::DeepSpace) = 8, 8
Ahorn.resizable(entity::DeepSpace) = true, true

Ahorn.selection(entity::DeepSpace) = Ahorn.getEntityRectangle(entity)


function Ahorn.render(ctx::Ahorn.Cairo.CairoContext, entity::DeepSpace, room::Maple.Room)
    width = Int(get(entity.data, "width", 32))
    height = Int(get(entity.data, "height", 32))

	realEdgeColor = (172.0,41.0,242.0, 255.0) ./ 255
	

	realCenterColor = (136.0,1.0,208.0,255.0) ./ 255

    Ahorn.drawRectangle(ctx, 0, 0, width, height, realCenterColor, realEdgeColor)
end
end
