local drawableSprite = require("structs.drawable_sprite")
local utils = require("utils")

local RainbowDecal = {}

local versionCheck = require("mods").requireFromPlugin("libraries.MoreLoennPlugins.versionCheck")
if not versionCheck.validModVersion("JackalHelper", "1.6.8")
  then return {}
end
RainbowDecal.associatedMods = { "JackalHelper" }

RainbowDecal.name = "JackalHelper/RainbowDecal"
RainbowDecal.depth = 0
RainbowDecal.placements = {
    name = "default",
    data = {
        directory = "JackalHelper/cryobotRainbow",
        wiggle = true
    }
}

function RainbowDecal.sprite(room, entity)
    return drawableSprite.fromTexture(entity.directory, entity)
end

function RainbowDecal.selection(room, entity)
    local rect = utils.rectangle(entity.x - 7, entity.y - 7, 14, 14)
    return rect
end

return RainbowDecal