module SusanModuleBlackBooster

using ..Ahorn, Maple

@mapdef Entity "SusanHelper/FollowBooster" BlackBooster(x::Integer, y::Integer, speedBurst::Number=3.0, retentionRate::Number=9.6, rotation::Integer=0)

rotations = [0, 90, 180, 270]

const placements = Ahorn.PlacementDict(
    "Mooster (Sprites.xml)(Susan Helper)" => Ahorn.EntityPlacement(
        BlackBooster
    )
)

sprite = "objects/boostVoid/booster00"

Ahorn.editingOptions(entity::BlackBooster) = Dict{String, Any}(
    "rotation" => rotations
)

function Ahorn.selection(entity::BlackBooster)
    x, y = Ahorn.position(entity)

    return Ahorn.Rectangle(x-9, y-9, 18, 18)
end

Ahorn.render(ctx::Ahorn.Cairo.CairoContext, entity::BlackBooster, room::Maple.Room) = Ahorn.drawSprite(ctx, sprite, 0, 0)

end