module SusanHelperInkWater

using ..Ahorn, Maple

@mapdef Entity "SusanHelper/InkWater" DeadlyWater(x::Integer, y::Integer, width::Integer=Maple.defaultBlockWidth, height::Integer=Maple.defaultBlockHeight, hasRays::Bool=false, hasBottom::Bool=false)



const placements = Ahorn.PlacementDict(
    "Ink Water (Susan Helper)" => Ahorn.EntityPlacement(
        DeadlyWater,
        "rectangle"
    ),
)

Ahorn.editingOptions(entity::DeadlyWater) = Dict{String, Any}(
)

Ahorn.minimumSize(entity::DeadlyWater) = 8, 8
Ahorn.resizable(entity::DeadlyWater) = true, true

Ahorn.selection(entity::DeadlyWater) = Ahorn.getEntityRectangle(entity)

function Ahorn.render(ctx::Ahorn.Cairo.CairoContext, entity::DeadlyWater, room::Maple.Room)
    x = Int(get(entity.data, "x", 0))
    y = Int(get(entity.data, "y", 0))

    width = Int(get(entity.data, "width", 32))
    height = Int(get(entity.data, "height", 32))

    Ahorn.drawRectangle(ctx, 0, 0, width, height, (1.0, 1.0, 1.0, 0.6), (1.0, 1.0, 1.0, 1.0))
end

end