module SpirialisFixedLaunchSpring

using ..Ahorn, Maple

@mapdef Entity "spirialis/fixedlaunchspring" FixedLaunchSpring(x::Integer, y::Integer, spriteDirectory::String="objects/spirialis/fixedlaunchspring", playerCanUse::Bool=true, launchOffsetX::Number=0.0, launchOffsetY::Number=0.0)
@mapdef Entity "spirialis/fixedlaunchspringright" FixedLaunchSpringRight(x::Integer, y::Integer, spriteDirectory::String="objects/spirialis/fixedlaunchspring", playerCanUse::Bool=true, launchOffsetX::Number=0.0, launchOffsetY::Number=0.0)
@mapdef Entity "spirialis/fixedlaunchspringleft" FixedLaunchSpringLeft(x::Integer, y::Integer, spriteDirectory::String="objects/spirialis/fixedlaunchspring", playerCanUse::Bool=true, launchOffsetX::Number=0.0, launchOffsetY::Number=0.0)

const placements = Ahorn.PlacementDict(
    "Fixed Launch Spring (Up) (Spirialis)" => Ahorn.EntityPlacement(
        FixedLaunchSpring
    ),
    "Fixed Launch Spring (Left) (Spirialis)" => Ahorn.EntityPlacement(
        FixedLaunchSpringRight
    ),
    "Fixed Launch Spring (Right) (Spirialis)" => Ahorn.EntityPlacement(
        FixedLaunchSpringLeft
    ),
)

function Ahorn.selection(entity::FixedLaunchSpring)
    x, y = Ahorn.position(entity)

    return Ahorn.Rectangle(x - 6, y - 3, 12, 5)
end

function Ahorn.selection(entity::FixedLaunchSpringLeft)
    x, y = Ahorn.position(entity)

    return Ahorn.Rectangle(x - 1, y - 6, 5, 12)
end

function Ahorn.selection(entity::FixedLaunchSpringRight)
    x, y = Ahorn.position(entity)

    return Ahorn.Rectangle(x - 4, y - 6, 5, 12)
end

Ahorn.render(ctx::Ahorn.Cairo.CairoContext, entity::FixedLaunchSpring, room::Maple.Room) = Ahorn.drawSprite(ctx, get(entity, "spriteDirectory", "objects/spirialis/fixedlaunchspring") * "/00.png", 0, -8)
Ahorn.render(ctx::Ahorn.Cairo.CairoContext, entity::FixedLaunchSpringLeft, room::Maple.Room) = Ahorn.drawSprite(ctx, get(entity, "spriteDirectory", "objects/spirialis/fixedlaunchspring") * "/00.png", 24, 0, rot=pi / 2)
Ahorn.render(ctx::Ahorn.Cairo.CairoContext, entity::FixedLaunchSpringRight, room::Maple.Room) = Ahorn.drawSprite(ctx, get(entity, "spriteDirectory", "objects/spirialis/fixedlaunchspring") * "/00.png", -8, 16, rot=-pi / 2)

end