module LunaticHelperCustomRefill

using ..Ahorn, Maple

@mapdef Entity "LunaticHelper/CustomRefill" CustomRefill(
	x::Integer,
	y::Integer,

	twoDash::Bool=false,
	respawn::Number=2.5
)

const placements = Ahorn.PlacementDict(
	"Custom Refill (Lunatic Helper)" => Ahorn.EntityPlacement(
		CustomRefill
	),

	"Custom Refill (Two Dashes) (Lunatic Helper)" => Ahorn.EntityPlacement(
		CustomRefill,
		"point",
		Dict{String, Any}(
			"twoDash" => true
		)
	)
)

spriteOneDash = "objects/refill/idle00"
spriteTwoDash = "objects/refillTwo/idle00"

function getSprite(entity::CustomRefill)
	twoDash = get(entity.data, "twoDash", false)

	return twoDash ? spriteTwoDash : spriteOneDash
end

function Ahorn.selection(entity::CustomRefill)
	x, y = Ahorn.position(entity)
	sprite = getSprite(entity)

	return Ahorn.getSpriteRectangle(sprite, x, y)
end

function Ahorn.render(ctx::Ahorn.Cairo.CairoContext, entity::CustomRefill, room::Maple.Room)
	sprite = getSprite(entity)
	Ahorn.drawSprite(ctx, sprite, 0, 0)
end

end