local drawableSpriteStruct = require("structs.drawable_sprite")

local specialRefill = {}
specialRefill.name = "MoreDasheline/SpecialRefill"
specialRefill.placements = {
    name = "normal",
    data = {
        oneUse = false,
        dashes = 3,
        directory = "moreDasheline/refill", -- .. /idle00
        particleColor = "",
        onPlayersfx = "event:/game/general/diamond_touch",
        respawnsfx = "event:/game/general/diamond_return",
        refillStamina = true,
    }
}

specialRefill.fieldInformation = {
    dashes = {
        fieldType = "integer",
        minimumValue = 0,
    },
    --[[ color fields don't accept empty strings yet :(
    particleColor = {
        fieldType = "color",
        allowXNAColors = true,
    }
    ]]
}

local function getCustomSprite(entity, spritePropertyName, spritePostfix, fallback)
    local sprite = nil

    local path = entity[spritePropertyName]
    if path then
        sprite = drawableSpriteStruct.fromTexture(path .. (spritePostfix or ""), entity)
    end

    if not sprite and fallback then
        sprite = drawableSpriteStruct.fromTexture(fallback, entity)
    end

    return sprite
end

function specialRefill.sprite(room, entity)
    return getCustomSprite(entity, "directory", "/idle00", "moreDasheline/refill/idle00")
end

return specialRefill