module ContortHelperAlphaLerpLightSources

using ..Ahorn, Maple

# Mapdef

@mapdef Entity "ContortHelper/AlphaLerpLightSource" AlphaLerpLightSource(
	x::Integer,
	y::Integer,

	color::String="White",
	radius::Number=48.0,

	startFade::Integer=24,
	endFade::Integer=48,

	alphaA::Number=0.5,
	alphaB::Number=1.0,
	alphaEaser::String="CubeInOut",
	alphaSpeed::Number=1.0,

	inverted::String="False"
)

@mapdef Entity "ContortHelper/AlphaLerpLightSourcePath" AlphaLerpLightSourcePath(
	x::Integer,
	y::Integer,

	color::String="White",
	radius::Number=48.0,

	startFade::Integer=24,
	endFade::Integer=48,

	alphaA::Number=0.5,
	alphaB::Number=1.0,
	alphaEaser::String="CubeInOut",
	alphaSpeed::Number=1.0,

	inverted::String="False",

	moveSpeed::Number=1.181818,
	moveEaser::String="CubeInOut"
)

# Placements

const placements = Ahorn.PlacementDict()

for (name, startFade, endFade, radius) in Ahorn.ContortHelper.lightvariants
	placements["Alpha-Lerp Light ($(name)) (Contort Helper)"] = Ahorn.EntityPlacement(
		AlphaLerpLightSource,
		"point",
		Dict{String,Any}(
			"startFade" => startFade,
			"endFade" => endFade,
			"radius" => radius
		)
	)
	
	placements["Alpha-Lerp Light ($(name), Path) (Contort Helper)"] = Ahorn.EntityPlacement(
		AlphaLerpLightSourcePath,
		"point",
		Dict{String,Any}(
			"startFade" => startFade,
			"endFade" => endFade,
			"radius" => radius
		),
		function (entity)
			entity.data["nodes"] = [(Int(entity.data["x"]) + 16, Int(entity.data["y"]))]
		end
	)
end

# AlphaLerpLightSource

function Ahorn.selection(entity::AlphaLerpLightSource)
	nodes = get(entity.data, "nodes", ())
	x, y = Ahorn.position(entity)
	
	res = Ahorn.Rectangle[Ahorn.getSpriteRectangle(Ahorn.ContortHelper.alphalerplightsource, x, y)]
	
	for node in nodes
		nx, ny = Int.(node)
		push!(res, Ahorn.getSpriteRectangle(Ahorn.ContortHelper.alphalerplightsource, nx, ny))
	end

	return res
end

function Ahorn.renderSelectedAbs(ctx::Ahorn.Cairo.CairoContext, entity::AlphaLerpLightSource)
	px, py = Ahorn.position(entity)
	nodes = get(entity.data, "nodes", Tuple{Int, Int}[])

	for node in nodes
		nx, ny = Int.(node)

		Ahorn.drawArrow(ctx, px, py, nx, ny, Ahorn.colors.selection_selected_fc, headLength=6)
		Ahorn.drawSprite(ctx, Ahorn.ContortHelper.alphalerplightsource, nx, ny)
		px, py = nx, ny
	end
end

Ahorn.render(ctx::Ahorn.Cairo.CairoContext, entity::AlphaLerpLightSource, room::Maple.Room) = Ahorn.drawSprite(ctx, Ahorn.ContortHelper.alphalerplightsource, 0, 0)

Ahorn.editingOptions(entity::AlphaLerpLightSource) = Dict{String, Any}(
	"color" => sort(collect(keys(Ahorn.XNAColors.colors))),
	"alphaEaser" => Ahorn.ContortHelper.easers,
	"inverted" => Ahorn.ContortHelper.boolorrand
)

# AlphaLerpLightSourcePath

Ahorn.nodeLimits(entity::AlphaLerpLightSourcePath) = 1, 1

function Ahorn.selection(entity::AlphaLerpLightSourcePath)
	nodes = get(entity.data, "nodes", ())
	x, y = Ahorn.position(entity)
	
	res = Ahorn.Rectangle[Ahorn.getSpriteRectangle(Ahorn.ContortHelper.alphalerplightsourcepath, x, y)]
	
	for node in nodes
		nx, ny = Int.(node)
		push!(res, Ahorn.getSpriteRectangle(Ahorn.ContortHelper.alphalerplightsourcepath, nx, ny))
	end

	return res
end

function Ahorn.renderSelectedAbs(ctx::Ahorn.Cairo.CairoContext, entity::AlphaLerpLightSourcePath)
	px, py = Ahorn.position(entity)
	nodes = get(entity.data, "nodes", Tuple{Int, Int}[])

	for node in nodes
		nx, ny = Int.(node)

		Ahorn.drawArrow(ctx, px, py, nx, ny, Ahorn.colors.selection_selected_fc, headLength=6)
		Ahorn.drawSprite(ctx, Ahorn.ContortHelper.alphalerplightsourcepath, nx, ny)
		px, py = nx, ny
	end
end

Ahorn.render(ctx::Ahorn.Cairo.CairoContext, entity::AlphaLerpLightSourcePath, room::Maple.Room) = Ahorn.drawSprite(ctx, Ahorn.ContortHelper.alphalerplightsourcepath, 0, 0)

Ahorn.editingOptions(entity::AlphaLerpLightSourcePath) = Dict{String, Any}(
	"color" => sort(collect(keys(Ahorn.XNAColors.colors))),
	"alphaEaser" => Ahorn.ContortHelper.easers,
	"inverted" => Ahorn.ContortHelper.boolorrand,
	"moveEaser" => Ahorn.ContortHelper.easers
)

end