
module ContortHelperConfettiControllers

using ..Ahorn, Maple

# Mapdef

@mapdef Entity "ContortHelper/ConfettiSpawnZoneController" ConfettiSpawnZoneController(
	x::Integer,
	y::Integer,

	audioEvent::String="event:/game/07_summit/checkpoint_confetti",
	amount::Integer=30,
	depth::Integer=-10000,

	textures::String="particles/confetti",
	colors::String="fe2074,205efe,cefe20",
	offsetXMinimum::Number=-3.0,
	offsetXMaximum::Number=3.0,
	offsetYMinimum::Number=-3.0,
	offsetYMaximum::Number=3.0,
	durationMinimum::Number=2.0,
	durationMaximum::Number=4.0,
	fallSpreadMinimum::Number=0.0,
	fallSpreadMaximum::Number=0.0,
	fallSpeedMinimum::Number=20.0,
	fallSpeedMaximum::Number=20.0,
	rotation::Number=4.0,

	delaySpawnMinimum::Number=0.25,
	delaySpawnMaximum::Number=0.25,
	amountPerUpdate::Integer=1
)

@mapdef Entity "ContortHelper/ConfettiSpawnAttacherController" ConfettiSpawnAttacherController(
	x::Integer,
	y::Integer,

	attachTo::String="Player",

	audioEvent::String="event:/game/07_summit/checkpoint_confetti",
	amount::Integer=30,
	depth::Integer=-10000,

	textures::String="particles/confetti",
	colors::String="fe2074,205efe,cefe20",
	offsetXMinimum::Number=-3.0,
	offsetXMaximum::Number=3.0,
	offsetYMinimum::Number=-3.0,
	offsetYMaximum::Number=3.0,
	durationMinimum::Number=2.0,
	durationMaximum::Number=4.0,
	fallSpreadMinimum::Number=0.0,
	fallSpreadMaximum::Number=0.0,
	fallSpeedMinimum::Number=20.0,
	fallSpeedMaximum::Number=20.0,
	rotation::Number=4.0,

	delaySpawnMinimum::Number=0.25,
	delaySpawnMaximum::Number=0.25,
	amountPerUpdate::Integer=1,
	confettiAllAtOnce::Bool=false
)

# Placements

const placements = Ahorn.PlacementDict(
	"Confetti Zone Controller (Contort Helper)" => Ahorn.EntityPlacement(
		ConfettiSpawnZoneController
	),
	"Confetti Attacher Controller (Contort Helper)" => Ahorn.EntityPlacement(
		ConfettiSpawnAttacherController
	)
)

# ConfettiSpawnZoneController

function Ahorn.selection(entity::ConfettiSpawnZoneController)
	nodes = get(entity.data, "nodes", ())
	x, y = Ahorn.position(entity)
	
	res = Ahorn.Rectangle[Ahorn.getSpriteRectangle(Ahorn.ContortHelper.confetticontroller, x, y)]
	
	for node in nodes
		nx, ny = Int.(node)
		push!(res, Ahorn.getSpriteRectangle(Ahorn.ContortHelper.confetticontroller, nx, ny))
	end

	return res
end

function Ahorn.renderSelectedAbs(ctx::Ahorn.Cairo.CairoContext, entity::ConfettiSpawnZoneController)
	px, py = Ahorn.position(entity)
	nodes = get(entity.data, "nodes", Tuple{Int, Int}[])

	for node in nodes
		nx, ny = Int.(node)

		Ahorn.drawArrow(ctx, px, py, nx, ny, Ahorn.colors.selection_selected_fc, headLength=6)
		Ahorn.drawSprite(ctx, Ahorn.ContortHelper.confetticontroller, nx, ny)
		px, py = nx, ny
	end
end

Ahorn.render(ctx::Ahorn.Cairo.CairoContext, entity::ConfettiSpawnZoneController, room::Maple.Room) = Ahorn.drawSprite(ctx, Ahorn.ContortHelper.confetticontroller, 0, 0)

Ahorn.editingOptions(entity::ConfettiSpawnZoneController) = Dict{String, Any}(
	"depth" => Ahorn.ContortHelper.depths,
	"colors" => sort(collect(keys(Ahorn.XNAColors.colors)))
)

# ConfettiSpawnAttacherController

function Ahorn.selection(entity::ConfettiSpawnAttacherController)
	nodes = get(entity.data, "nodes", ())
	x, y = Ahorn.position(entity)
	
	res = Ahorn.Rectangle[Ahorn.getSpriteRectangle(Ahorn.ContortHelper.confetticontroller, x, y)]
	
	for node in nodes
		nx, ny = Int.(node)
		push!(res, Ahorn.getSpriteRectangle(Ahorn.ContortHelper.confetticontroller, nx, ny))
	end

	return res
end

function Ahorn.renderSelectedAbs(ctx::Ahorn.Cairo.CairoContext, entity::ConfettiSpawnAttacherController)
	px, py = Ahorn.position(entity)
	nodes = get(entity.data, "nodes", Tuple{Int, Int}[])

	for node in nodes
		nx, ny = Int.(node)

		Ahorn.drawArrow(ctx, px, py, nx, ny, Ahorn.colors.selection_selected_fc, headLength=6)
		Ahorn.drawSprite(ctx, Ahorn.ContortHelper.confetticontroller, nx, ny)
		px, py = nx, ny
	end
end

Ahorn.render(ctx::Ahorn.Cairo.CairoContext, entity::ConfettiSpawnAttacherController, room::Maple.Room) = Ahorn.drawSprite(ctx, Ahorn.ContortHelper.confetticontroller, 0, 0)

Ahorn.editingOptions(entity::ConfettiSpawnAttacherController) = Dict{String, Any}(
	"attachTo" => Ahorn.ContortHelper.attaches,
	"depth" => Ahorn.ContortHelper.depths,
	"colors" => sort(collect(keys(Ahorn.XNAColors.colors)))
)

end