module ContortHelperCustomInteractions

using ..Ahorn, Maple

# Mapdef

@mapdef Entity "ContortHelper/CustomMemo" CustomMemo(
	x::Integer,
	y::Integer,
	width::Integer=Maple.defaultBlockWidth,
	height::Integer=Maple.defaultBlockHeight,

	dialogFlag::String="",

	beforeDialog::String="",
	beforeDialogDelay::Number=0.1,

	afterDialog::String="",
	afterDialogDelay::Number=0.1,

	poemDialog::String="",
	poemColor::String="Black",

	poemInEaser::String="CubeInOut",
	poemOutEaser::String="CubeInOut",

	poemInAudioEvent::String="event:/game/03_resort/memo_in",
	poemOutAudioEvent::String="event:/game/03_resort/memo_out",

	paper::String="memo/memo",
	title::String="memo/title_english"
)

@mapdef Entity "ContortHelper/CustomNote" CustomNote(
	x::Integer,
	y::Integer,
	width::Integer=Maple.defaultBlockWidth,
	height::Integer=Maple.defaultBlockHeight,

	dialogFlag::String="",

	beforeDialog::String="",
	beforeDialogDelay::Number=0.1,

	afterDialog::String="",
	afterDialogDelay::Number=0.1,

	poemDialog::String="",
	poemColor::String="Black",

	poemInEaser::String="CubeInOut",
	poemOutEaser::String="CubeInOut",

	poemInAudioEvent::String="event:/game/03_resort/memo_in",
	poemOutAudioEvent::String="event:/game/03_resort/memo_out",

	paper::String="poempage",
	paperOffsetX::Number=0.0,
	paperOffsetY::Number=0.0,
)

# Placements

const placements = Ahorn.PlacementDict(
	"Custom Memo (Contort Helper)" => Ahorn.EntityPlacement(
		CustomMemo,
		"rectangle",
		Dict{String,Any}(),
		function (entity)
			entity.data["nodes"] = [(Int(entity.data["x"]) + Int(entity.data["width"]) + 8, Int(entity.data["y"]))]
		end
	),
	"Custom Note (Contort Helper)" => Ahorn.EntityPlacement(
		CustomNote,
		"rectangle",
		Dict{String,Any}(),
		function (entity)
			entity.data["nodes"] = [(Int(entity.data["x"]) + Int(entity.data["width"]) + 8, Int(entity.data["y"]))]
		end
	)
)

# CustomMemo

Ahorn.nodeLimits(entity::CustomMemo) = 1, 1
Ahorn.minimumSize(entity::CustomMemo) = 8, 8
Ahorn.resizable(entity::CustomMemo) = true, true

const color = (1.0, 0.9, 0.5, 0.4)
const outline = (0.9, 1.0, 0.7, 0.6)
const text1 = "Custom Memo"
const text2 = "Custom Note"

function Ahorn.selection(entity::CustomMemo, room::Maple.Room, node::Int=0)
	x, y = Int(entity.x), Int(entity.y)
	width, height = Int(entity.width), Int(entity.height)
	nodes = get(entity.data, "nodes", Tuple{Int, Int}[])

	if isempty(nodes)
		return Ahorn.Rectangle(x, y, width, height)

	else
		res = Ahorn.Rectangle[Ahorn.Rectangle(x, y, width, height)]

		for node in nodes
			nx, ny = Int.(node)

			push!(res, Ahorn.Rectangle(nx, ny, 8, 8))
		end

		return res
	end
end

function Ahorn.render(ctx::Ahorn.Cairo.CairoContext, entity::CustomMemo, room::Maple.Room)
	if ctx.ptr != C_NULL
		Ahorn.Cairo.save(ctx)

		x, y = Ahorn.position(entity)
		w, h = Int(entity.width), Int(entity.height)
		
		x /= typemax(Int)
		y /= typemax(Int)

		Ahorn.rectangle(ctx, x, y, w, h)
		Ahorn.clip(ctx)

		Ahorn.drawRectangle(ctx, x, y, w, h, color, outline)
		Ahorn.drawCenteredText(ctx, text1, x, y, w, h)

		Ahorn.restore(ctx)
	end
end

function Ahorn.renderSelectedAbs(ctx::Ahorn.Cairo.CairoContext, entity::CustomMemo)
	x, y = Int(entity.data["x"]), Int(entity.data["y"])
	width, height = Int(entity.data["width"]), Int(entity.data["height"])
	nodes = get(entity.data, "nodes", Tuple{Int, Int}[])
	offsetCenterX, offsetCenterY = floor(Int, width / 2), floor(Int, height / 2)

	for node in nodes
		nx, ny = Int.(node)

		Ahorn.drawArrow(ctx, x + offsetCenterX, y + offsetCenterY, nx + 4, ny + 4, outline, headLength=6)
		Ahorn.drawRectangle(ctx, nx, ny, 8, 8, color, outline)
	end
end

Ahorn.editingOptions(entity::CustomMemo) = Dict{String, Any}(
	"poemColor" => sort(collect(keys(Ahorn.XNAColors.colors))),
	"poemInEaser" => Ahorn.ContortHelper.easers,
	"poemOutEaser" => Ahorn.ContortHelper.easers
)

# CustomNote

Ahorn.nodeLimits(entity::CustomNote) = 1, 1
Ahorn.minimumSize(entity::CustomNote) = 8, 8
Ahorn.resizable(entity::CustomNote) = true, true

function Ahorn.selection(entity::CustomNote, room::Maple.Room, node::Int=0)
	x, y = Int(entity.x), Int(entity.y)
	width, height = Int(entity.width), Int(entity.height)
	nodes = get(entity.data, "nodes", Tuple{Int, Int}[])

	if isempty(nodes)
		return Ahorn.Rectangle(x, y, width, height)

	else
		res = Ahorn.Rectangle[Ahorn.Rectangle(x, y, width, height)]

		for node in nodes
			nx, ny = Int.(node)

			push!(res, Ahorn.Rectangle(nx, ny, 8, 8))
		end

		return res
	end
end

function Ahorn.render(ctx::Ahorn.Cairo.CairoContext, entity::CustomNote, room::Maple.Room)
	if ctx.ptr != C_NULL
		Ahorn.Cairo.save(ctx)

		x, y = Ahorn.position(entity)
		w, h = Int(entity.width), Int(entity.height)
		
		x /= typemax(Int)
		y /= typemax(Int)

		Ahorn.rectangle(ctx, x, y, w, h)
		Ahorn.clip(ctx)

		Ahorn.drawRectangle(ctx, x, y, w, h, color, outline)
		Ahorn.drawCenteredText(ctx, text2, x, y, w, h)

		Ahorn.restore(ctx)
	end
end

function Ahorn.renderSelectedAbs(ctx::Ahorn.Cairo.CairoContext, entity::CustomNote)
	x, y = Int(entity.data["x"]), Int(entity.data["y"])
	width, height = Int(entity.data["width"]), Int(entity.data["height"])
	nodes = get(entity.data, "nodes", Tuple{Int, Int}[])
	offsetCenterX, offsetCenterY = floor(Int, width / 2), floor(Int, height / 2)

	for node in nodes
		nx, ny = Int.(node)

		Ahorn.drawArrow(ctx, x + offsetCenterX, y + offsetCenterY, nx + 4, ny + 4, outline, headLength=6)
		Ahorn.drawRectangle(ctx, nx, ny, 8, 8, color, outline)
	end
end

Ahorn.editingOptions(entity::CustomNote) = Dict{String, Any}(
	"poemColor" => sort(collect(keys(Ahorn.XNAColors.colors))),
	"poemInEaser" => Ahorn.ContortHelper.easers,
	"poemOutEaser" => Ahorn.ContortHelper.easers
)

end