module ContortHelperGlitchEffectController

using ..Ahorn, Maple

# Mapdef

@mapdef Entity "ContortHelper/GlitchEffectController" GlitchEffectController(
	x::Integer,
	y::Integer,

	enterValue::Number=0.35,
	leaveValue::Number=0.0
)

# Placements

const placements = Ahorn.PlacementDict(
	"Glitch Effect Controller ($(name)) (Contort Helper)" => Ahorn.EntityPlacement(
		GlitchEffectController,
		"point",
		Dict{String,Any}(
			"enterValue" => enterValue
		)
	) for (name, enterValue) in Ahorn.ContortHelper.glitchvariants
)

# GlitchEffectController

function Ahorn.selection(entity::GlitchEffectController)
	nodes = get(entity.data, "nodes", ())
	x, y = Ahorn.position(entity)
	
	res = Ahorn.Rectangle[Ahorn.getSpriteRectangle(Ahorn.ContortHelper.glitcheffectcontroller, x, y)]
	
	for node in nodes
		nx, ny = Int.(node)
		push!(res, Ahorn.getSpriteRectangle(Ahorn.ContortHelper.glitcheffectcontroller, nx, ny))
	end

	return res
end

function Ahorn.renderSelectedAbs(ctx::Ahorn.Cairo.CairoContext, entity::GlitchEffectController)
	px, py = Ahorn.position(entity)
	nodes = get(entity.data, "nodes", Tuple{Int, Int}[])

	for node in nodes
		nx, ny = Int.(node)

		Ahorn.drawArrow(ctx, px, py, nx, ny, Ahorn.colors.selection_selected_fc, headLength=6)
		Ahorn.drawSprite(ctx, Ahorn.ContortHelper.glitcheffectcontroller, nx, ny)
		px, py = nx, ny
	end
end

Ahorn.render(ctx::Ahorn.Cairo.CairoContext, entity::GlitchEffectController, room::Maple.Room) = Ahorn.drawSprite(ctx, Ahorn.ContortHelper.glitcheffectcontroller, 0, 0)

end