module ContortHelperAnxietyEffectTrigger

using ..Ahorn, Maple

# Mapdef

@mapdef Trigger "ContortHelper/AnxietyEffectTrigger" AnxietyEffectTrigger(
	x::Integer,
	y::Integer,
	width::Integer=Maple.defaultTriggerWidth,
	height::Integer=Maple.defaultTriggerHeight,

	position::String="NoEffect",
	from::Number=0.0,
	to::Number=0.8,

	delay::Number=0.0,
	oneUse::Bool=false,
	persistent::Bool=false
)

# Placements

const placements = Ahorn.PlacementDict(
	"Anxiety Effect Trigger ($(name)) (Contort Helper)" => Ahorn.EntityPlacement(
		AnxietyEffectTrigger,
		"rectangle",
		Dict{String,Any}(
			"to" => enterValue
		)
	) for (name, enterValue) in Ahorn.ContortHelper.anxietyvariants
)

# AnxietyEffectTrigger

Ahorn.editingOptions(entity::AnxietyEffectTrigger) = Dict{String,Any}(
	"position" => Maple.trigger_position_modes
)

end