module ContortHelperBurstRemoverTrigger

using ..Ahorn, Maple

# Mapdef

@mapdef Trigger "ContortHelper/BurstRemoverTrigger" BurstRemoverTrigger(
	x::Integer,
	y::Integer,
	width::Integer=Maple.defaultTriggerWidth,
	height::Integer=Maple.defaultTriggerHeight,

	untilReenter::Bool=true,

	neededFlags::String="",
	flagsAfterInvoke::String="",

	delay::Number=0.0,
	occurOnEnter::Bool=true,
	oneUse::Bool=false,
	persistent::Bool=false
)

# Placements

const placements = Ahorn.PlacementDict(
	"Burst Remover Trigger $(untilReenter ? "(Until Reload) " : "")(Contort Helper)" => Ahorn.EntityPlacement(
		BurstRemoverTrigger,
		"rectangle"
	) for untilReenter in [true, false]
)

end