module ContortHelperTeleportationTriggers

using ..Ahorn, Maple

# Mapdef

@mapdef Trigger "ContortHelper/TeleportationTriggerLevel5" TeleportationTrigger5(
	x::Integer,
	y::Integer,
	width::Integer=Maple.defaultTriggerWidth,
	height::Integer=Maple.defaultTriggerHeight,

	roomName::String="",
	roomNameForGolden::String="",
	targetTag::String="",

	musicEvent::String="",
	ambienceEvent::String="",
	startAudioEvent::String="",
	transitionAudioEvent::String="event:/new_content/game/10_farewell/glitch_short",
	endAudioEvent::String="",

	startDuration::Number=0.1,

	glitchMultiplier::Number=0.25,
	startGlitchDuration::Number=0.1,
	endGlitchDuration::Number=0.3,
	glitchDelay::Number=0.0,
	startGlitchEaser="Linear",
	endGlitchEaser="Linear",

	anxietyMultiplier::Number=0.25,
	startAnxietyDuration::Number=0.1,
	endAnxietyDuration::Number=0.3,
	anxietyDelay::Number=0.0,
	startAnxietyEaser="Linear",
	endAnxietyEaser="Linear",

	rumbleStrength::String="None",
	rumbleLength::String="None",

	specificRumbleStrength::Number=0.0,
	specificRumbleLength::Number=0.0,

	screenShake::Number=0.0,
	screenShakeDirectionX::Number=1.0,
	screenShakeDirectionY::Number=1.0,
	useDirectionalShake::Bool=false,

	screenFreeze::Number=0.0,

	useLightningStrike::Bool=false,
	flashColor::String="White",
	flashColorAlpha::Number=0.6,
	flashOverPlayer::Bool=false,
	useFlash::Bool=false,

	useStartScreenWipe::Bool=false,
	useEndScreenWipe::Bool=false,

	changePlayerX::Bool=true,
	changePlayerY::Bool=true,
	changeCameraX::Bool=true,
	changeCameraY::Bool=true,

	rememberDashes::Bool=true,
	rememberFacing::Bool=true,

	momentumModifierX::Number=0.0,
	momentumModifierY::Number=0.0,
	momentumOperation::String="Addition",
	momentumOnlyX::Bool=false,
	momentumOnlyY::Bool=false,

	spawnPointIsNearestSpawn::Bool=false,
	onlyInvokeWithGolden::Bool=false,
	useLegacyCamera::Bool=false,
	reloadRoom::Bool=true,
	noEffects::Bool=false,

	neededFlags::String="",
	flagsAfterInvoke::String="",

	occurOnEnter::Bool=true,
	oneUse::Bool=false,
	persistent::Bool=false
)

@mapdef Trigger "ContortHelper/TeleportationTriggerLevel4" TeleportationTrigger4(
	x::Integer,
	y::Integer,
	width::Integer=Maple.defaultTriggerWidth,
	height::Integer=Maple.defaultTriggerHeight,

	roomName::String="",
	roomNameForGolden::String="",
	targetTag::String="",

	musicEvent::String="",
	transitionAudioEvent::String="event:/new_content/game/10_farewell/glitch_short",

	startDuration::Number=0.1,

	glitchMultiplier::Number=0.25,
	startGlitchDuration::Number=0.1,
	endGlitchDuration::Number=0.3,

	anxietyMultiplier::Number=0.25,
	startAnxietyDuration::Number=0.1,
	endAnxietyDuration::Number=0.3,

	rumbleStrength::String="None",
	rumbleLength::String="None",

	screenShake::Number=0.0,

	useLightningStrike::Bool=false,
	flashColor::String="White",
	flashColorAlpha::Number=0.6,
	flashOverPlayer::Bool=false,
	useFlash::Bool=false,

	useStartScreenWipe::Bool=false,
	useEndScreenWipe::Bool=false,

	changePlayerX::Bool=true,
	changePlayerY::Bool=true,

	momentumModifierX::Number=0.0,
	momentumModifierY::Number=0.0,
	momentumOperation::String="Addition",
	momentumOnlyX::Bool=false,
	momentumOnlyY::Bool=false,

	spawnPointIsNearestSpawn::Bool=false,
	onlyInvokeWithGolden::Bool=false,
	useLegacyCamera::Bool=false,
	reloadRoom::Bool=true,
	noEffects::Bool=false,

	neededFlags::String="",
	flagsAfterInvoke::String="",

	occurOnEnter::Bool=true,
	oneUse::Bool=false,
	persistent::Bool=false
)

@mapdef Trigger "ContortHelper/TeleportationTriggerLevel3" TeleportationTrigger3(
	x::Integer,
	y::Integer,
	width::Integer=Maple.defaultTriggerWidth,
	height::Integer=Maple.defaultTriggerHeight,

	roomName::String="",
	roomNameForGolden::String="",
	targetTag::String="",

	musicEvent::String="",
	transitionAudioEvent::String="event:/new_content/game/10_farewell/glitch_short",

	startDuration::Number=0.1,

	glitchMultiplier::Number=0.25,
	startGlitchDuration::Number=0.1,
	endGlitchDuration::Number=0.3,

	anxietyMultiplier::Number=0.25,
	startAnxietyDuration::Number=0.1,
	endAnxietyDuration::Number=0.3,

	screenShake::Number=0.0,

	changePlayerX::Bool=true,
	changePlayerY::Bool=true,

	momentumModifierX::Number=0.0,
	momentumModifierY::Number=0.0,
	momentumOperation::String="Addition",
	momentumOnlyX::Bool=false,
	momentumOnlyY::Bool=false,

	spawnPointIsNearestSpawn::Bool=false,
	onlyInvokeWithGolden::Bool=false,
	useLegacyCamera::Bool=false,
	reloadRoom::Bool=true,
	noEffects::Bool=false,

	neededFlags::String="",
	flagsAfterInvoke::String="",

	occurOnEnter::Bool=true,
	oneUse::Bool=false,
	persistent::Bool=false
)

@mapdef Trigger "ContortHelper/TeleportationTriggerLevel2" TeleportationTrigger2(
	x::Integer,
	y::Integer,
	width::Integer=Maple.defaultTriggerWidth,
	height::Integer=Maple.defaultTriggerHeight,

	roomName::String="",
	targetTag::String="",

	transitionAudioEvent::String="event:/new_content/game/10_farewell/glitch_short",

	startDuration::Number=0.1,

	glitchMultiplier::Number=0.25,
	startGlitchDuration::Number=0.1,
	endGlitchDuration::Number=0.3,

	screenShake::Number=0.0,

	changePlayerX::Bool=true,
	changePlayerY::Bool=true,

	spawnPointIsNearestSpawn::Bool=false,
	onlyInvokeWithGolden::Bool=false,
	useLegacyCamera::Bool=false,
	reloadRoom::Bool=true,
	noEffects::Bool=false,

	neededFlags::String="",
	flagsAfterInvoke::String="",

	occurOnEnter::Bool=true,
	oneUse::Bool=false,
	persistent::Bool=false
)

@mapdef Trigger "ContortHelper/TeleportationTriggerLevel1" TeleportationTrigger1(
	x::Integer,
	y::Integer,
	width::Integer=Maple.defaultTriggerWidth,
	height::Integer=Maple.defaultTriggerHeight,

	roomName::String="",
	targetTag::String="",

	startDuration::Number=0.1,

	spawnPointIsNearestSpawn::Bool=false,
	onlyInvokeWithGolden::Bool=false,
	useLegacyCamera::Bool=false,
	reloadRoom::Bool=true,
	noEffects::Bool=false,

	neededFlags::String="",
	flagsAfterInvoke::String="",

	occurOnEnter::Bool=true,
	oneUse::Bool=false,
	persistent::Bool=false
)

# Placements

const placements = Ahorn.PlacementDict(
	"Teleportation Trigger (Level 5, In-Level) (Contort Helper)" => Ahorn.EntityPlacement(
		TeleportationTrigger5,
		"rectangle",
		Dict{String,Any}(
			"reloadRoom" => false
		),
		function (trigger)
			trigger.data["nodes"] = [(Int(trigger.data["x"]) + Int(trigger.data["width"]) + 8, Int(trigger.data["y"]))]
		end
	),
	"Teleportation Trigger (Level 4, In-Level) (Contort Helper)" => Ahorn.EntityPlacement(
		TeleportationTrigger4,
		"rectangle",
		Dict{String,Any}(
			"reloadRoom" => false
		),
		function (trigger)
			trigger.data["nodes"] = [(Int(trigger.data["x"]) + Int(trigger.data["width"]) + 8, Int(trigger.data["y"]))]
		end
	),
	"Teleportation Trigger (Level 3, In-Level) (Contort Helper)" => Ahorn.EntityPlacement(
		TeleportationTrigger3,
		"rectangle",
		Dict{String,Any}(
			"reloadRoom" => false
		),
		function (trigger)
			trigger.data["nodes"] = [(Int(trigger.data["x"]) + Int(trigger.data["width"]) + 8, Int(trigger.data["y"]))]
		end
	),
	"Teleportation Trigger (Level 2, In-Level) (Contort Helper)" => Ahorn.EntityPlacement(
		TeleportationTrigger2,
		"rectangle",
		Dict{String,Any}(
			"reloadRoom" => false
		),
		function (trigger)
			trigger.data["nodes"] = [(Int(trigger.data["x"]) + Int(trigger.data["width"]) + 8, Int(trigger.data["y"]))]
		end
	),
	"Teleportation Trigger (Level 1, In-Level) (Contort Helper)" => Ahorn.EntityPlacement(
		TeleportationTrigger1,
		"rectangle",
		Dict{String,Any}(
			"reloadRoom" => false
		),
		function (trigger)
			trigger.data["nodes"] = [(Int(trigger.data["x"]) + Int(trigger.data["width"]) + 8, Int(trigger.data["y"]))]
		end
	)
)

for golden in [true, false]
	
	for range in [0, 2, 2]
		
		name = "$(golden ? ", Golden" : "")$(range == 1 ? ", H-Range" : "")$(range == 2 ? ", V-Range" : "")"
		
		placements["Teleportation Trigger (Level 5$(name))$(golden && range != 0 ? "\n" : " ")(Contort Helper)"] = Ahorn.EntityPlacement(
			TeleportationTrigger5,
			"rectangle",
			Dict{String,Any}(
				"onlyInvokeWithGolden" => golden,
				"changePlayerX" => range != 1,
				"changePlayerY" => range != 2
			)
		)
		placements["Teleportation Trigger (Level 4$(name))$(golden && range != 0 ? "\n" : " ")(Contort Helper)"] = Ahorn.EntityPlacement(
			TeleportationTrigger4,
			"rectangle",
			Dict{String,Any}(
				"onlyInvokeWithGolden" => golden,
				"changePlayerX" => range != 1,
				"changePlayerY" => range != 2
			)
		)
		placements["Teleportation Trigger (Level 3$(name))$(golden && range != 0 ? "\n" : " ")(Contort Helper)"] = Ahorn.EntityPlacement(
			TeleportationTrigger3,
			"rectangle",
			Dict{String,Any}(
				"onlyInvokeWithGolden" => golden,
				"changePlayerX" => range != 1,
				"changePlayerY" => range != 2
			)
		)
		placements["Teleportation Trigger (Level 2$(name))$(golden && range != 0 ? "\n" : " ")(Contort Helper)"] = Ahorn.EntityPlacement(
			TeleportationTrigger2,
			"rectangle",
			Dict{String,Any}(
				"onlyInvokeWithGolden" => golden,
				"changePlayerX" => range != 1,
				"changePlayerY" => range != 2
			)
		)
		
	end
	
	placements["Teleportation Trigger (Level 1$(golden ? ", Golden" : "")) (Contort Helper)"] = Ahorn.EntityPlacement(
		TeleportationTrigger1,
		"rectangle",
		Dict{String,Any}(
			"onlyInvokeWithGolden" => golden
		)
	)
	
end

# TeleportationTrigger5

Ahorn.nodeLimits(trigger::TeleportationTrigger5) = 0, 2

Ahorn.editingOptions(entity::TeleportationTrigger5) = Dict{String,Any}(
	"roomName" => sort([room.name for room in Ahorn.loadedState.map.rooms]),
	"roomNameForGolden" => sort([room.name for room in Ahorn.loadedState.map.rooms]),
	"musicEvent" => sort(collect(keys(Maple.Songs.songs))),
	"ambienceEvent" => sort(collect(keys(Maple.AmbientSounds.sounds))),
	"startGlitchEaser" => Ahorn.ContortHelper.easers,
	"endGlitchEaser" => Ahorn.ContortHelper.easers,
	"startAnxietyEaser" => Ahorn.ContortHelper.easers,
	"endAnxietyEaser" => Ahorn.ContortHelper.easers,
	"startTimeEaser" => Ahorn.ContortHelper.easers,
	"endTimeEaser" => Ahorn.ContortHelper.easers,
	"rumbleStrength" => Ahorn.ContortHelper.rumblestrength,
	"rumbleLength" => Ahorn.ContortHelper.rumblelength,
	"flashColor" => sort(collect(keys(Ahorn.XNAColors.colors))),
	"momentumOperation" => Ahorn.ContortHelper.operations
)

# TeleportationTrigger4

Ahorn.nodeLimits(trigger::TeleportationTrigger4) = 0, 2

Ahorn.editingOptions(entity::TeleportationTrigger4) = Dict{String,Any}(
	"roomName" => sort([room.name for room in Ahorn.loadedState.map.rooms]),
	"roomNameForGolden" => sort([room.name for room in Ahorn.loadedState.map.rooms]),
	"musicEvent" => sort(collect(keys(Maple.Songs.songs))),
	"rumbleStrength" => Ahorn.ContortHelper.rumblestrength,
	"rumbleLength" => Ahorn.ContortHelper.rumblelength,
	"flashColor" => sort(collect(keys(Ahorn.XNAColors.colors))),
	"momentumOperation" => Ahorn.ContortHelper.operations
)

# TeleportationTrigger3

Ahorn.nodeLimits(trigger::TeleportationTrigger3) = 0, 2

Ahorn.editingOptions(entity::TeleportationTrigger3) = Dict{String,Any}(
	"roomName" => sort([room.name for room in Ahorn.loadedState.map.rooms]),
	"roomNameForGolden" => sort([room.name for room in Ahorn.loadedState.map.rooms]),
	"musicEvent" => sort(collect(keys(Maple.Songs.songs))),
	"momentumOperation" => Ahorn.ContortHelper.operations
)

# TeleportationTrigger2

Ahorn.nodeLimits(trigger::TeleportationTrigger2) = 0, 2

Ahorn.editingOptions(entity::TeleportationTrigger2) = Dict{String,Any}(
	"roomName" => sort([room.name for room in Ahorn.loadedState.map.rooms])
)

# TeleportationTrigger1

Ahorn.nodeLimits(trigger::TeleportationTrigger1) = 0, 2

Ahorn.editingOptions(entity::TeleportationTrigger1) = Dict{String,Any}(
	"roomName" => sort([room.name for room in Ahorn.loadedState.map.rooms])
)

end