local SaladimHelperModule = require("#Celeste.Mod.SaladimHelper.SaladimHelperModule")
local CoinDisplayer = require("#Celeste.Mod.SaladimHelper.Entities.CoinDisplayer")

local function onBegin()
    local scene = engine.Scene
    local coinDisplay = nil
    local session = scene.Session
    local saladimSession = SaladimHelperModule.ModuleSession

    while true do
        if session:GetFlag("showCoinDisplay") then
            if not coinDisplay then
                CoinDisplayer.Display(scene, false, true);
                coinDisplay = getFirstEntity("Mod.SaladimHelper.Entities.CoinDisplayer")
            else
                coinDisplay.AlwaysDisplay = true
            end
        else
            if coinDisplay then
                coinDisplay.AlwaysDisplay = false
            end
        end

        local toRemove = session:GetCounter("coinsToAdd")
        if toRemove ~= 0 then
            saladimSession.CollectedCoinsAmount = saladimSession.CollectedCoinsAmount + toRemove
            session:SetCounter("coinsToAdd", 0)
            CoinDisplayer.Display(scene, false, true);
        end

        -- Expose coin counter to triggers
        session:SetCounter("coins", saladimSession.CollectedCoinsAmount)

        wait()
    end
end

local function onEnd()
end

return onBegin, onEnd