local lua_helper = celeste.Mod.LuaCutscenes.LuaHelper
local monocle = require("#monocle")

local function makeCoroutine(func)
    return monocle.Coroutine(lua_helper.LuaCoroutineToIEnumerator(coroutine.create(func)))
end

local function approachNPC()
    player.ForceCameraUpdate = true
    walkTo(-1097)
    player.Facing = getEnum("Celeste.Facings", "Left")
end

local approachNPCCoroutine

function onTalk()
    disableMovement()
    approachNPCCoroutine = makeCoroutine(approachNPC)
    talker:Add(approachNPCCoroutine)
    if not getFlag("spoken_to_buffy") then
        setFlag("spoken_to_buffy", true)
        say("Spooooky_GolfMap_BuffyWelcome")
    else
        say("Spooooky_GolfMap_BuffyChoice")
        choiceDialog({
            {
                "Spooooky_GolfMap_BuffyRed",
                onEnd = function ()
                getEntity("Mod.SpooookyHelper.Entities.GolfBall"):PaintBall("red")
                closeChoiceDialog()
                end
            },
            {
                "Spooooky_GolfMap_BuffyGreen",
                onEnd = function ()
                getEntity("Mod.SpooookyHelper.Entities.GolfBall"):PaintBall("green")
                closeChoiceDialog()
                end
            },
            {
                "Spooooky_GolfMap_BuffyBlue",
                onEnd = function ()
                getEntity("Mod.SpooookyHelper.Entities.GolfBall"):PaintBall("blue")
                closeChoiceDialog()
                end
            },
            {
                "Spooooky_GolfMap_BuffyClose",
                onEnd = function ()
                closeChoiceDialog()
                end
            },
        })
    end
    enableMovement()
end

function onEnd(room, wasSkipped)
    if approachNPCCoroutine then
        approachNPCCoroutine:Cancel()
        talker:Remove(approachNPCCoroutine)
    end
    enableMovement()
end