local lua_helper = celeste.Mod.LuaCutscenes.LuaHelper
local monocle = require("#monocle")

local function makeCoroutine(func)
    return monocle.Coroutine(lua_helper.LuaCoroutineToIEnumerator(coroutine.create(func)))
end

local function approachNPC()
    player.ForceCameraUpdate = true
    walkTo(-1216)
    player.Facing = getEnum("Celeste.Facings", "Right")
end

local approachNPCCoroutine

function onTalk()
    disableMovement()
    approachNPCCoroutine = makeCoroutine(approachNPC)
    talker:Add(approachNPCCoroutine)
    if not getFlag("spoken_to_duncan") then
        setFlag("spoken_to_duncan", true)
        say("Spooooky_GolfMap_Welcome")
    else
            if (getFlag("Spooooky_Course1Complete") and getFlag("Spooooky_Course2Complete") and getFlag("Spooooky_Course3Complete")) then
            say("Spooooky_GolfMap_WellDone")
        else
            say("Spooooky_GolfMap_Welcome2")
        end
    end
    enableMovement()
end

function onEnd(room, wasSkipped)
    if approachNPCCoroutine then
        approachNPCCoroutine:Cancel()
        talker:Remove(approachNPCCoroutine)
    end
    enableMovement()
end