local calc = require("#Monocle.Calc")
local dust = require("#Celeste.Dust")
local color = require("#Microsoft.Xna.Framework.Color")

function onBegin()
	engine.TimeRate = 0.45
	disableMovement()
    playSound("event:/game/05_mirror_temple/eyewall_bounce")
	player.DummyAutoAnimate = false
	player.Sprite:Play("roll")
    player.Speed = vector2(900, -325)
	player.ForceCameraUpdate = true;
    wait(0.05)
    player.Speed = vector2(825, -125)
    wait(0.05)
    player.Speed = vector2(775, -50)
    wait(0.05)
    player.Speed = vector2(650, 50)
    wait(0.05)
    player.Speed = vector2(550, 100)
    wait(0.05)
    player.Speed = vector2(450, 150)
    wait(0.05)
    player.Speed = vector2(350, 175)
    wait(0.05)
	player.Speed = vector2(250, 200)
	
    waitUntilOnGround()
    playSound("event:/game/06_reflection/badeline_pull_impact")
	getLevel():Flash(color.White)

	engine.TimeRate = 0.65
	local ground = player.Position.Y
	player.Dashes = 1
	
	-- playMusic("event:/new_content/music/lvl10/cinematic/bird_crash_first", 0)
--	playMusic("music_farewell_secondbirdcrash_cinematic", 0);
	player.Sprite:Play("roll")
	player.Speed = vector2(200, 0)
	player.DummyAutoAnimate = false
	player.DummyFriction = false
	player.ForceCameraUpdate = true;

	local p = 0
	while p < 1 do
		player.Speed = vector2(calc.Approach(player.Speed.X, 0, 160 * engine.DeltaTime), player.Speed.Y)

		if player.Speed ~= 0 and engine.Scene:OnInterval(0.1) then
			dust.BurstFG(player.Position, -math.pi / 2, 2)
		end

		wait(0)
		p = p + engine.DeltaTime
	end

	player.Speed = vector2(0, player.Speed.Y)
	player.DummyFriction = true
	
	wait(0.25)
	
	while engine.TimeRate < 1 do
		engine.TimeRate = calc.Approach(engine.TimeRate, 1, 4 * engine.DeltaTime)
		wait(0)
	end    
	
	player.ForceCameraUpdate = false

	wait(0.6)
	
	player.Sprite:Play("rollGetUp")
		
	wait(0.8)
end

function onEnd(room, wasSkipped)
	if wasSkipped then
        player.Sprite:Play("idle")
        instantTeleportTo(-6086, -1952)
	    player.Speed = vector2(0, 0);
	    player.DummyAutoAnimate = true
	    player.DummyFriction = true;
	    player.ForceCameraUpdate = false;
	end

	player.Speed = vector2(0, 0);
	player.DummyAutoAnimate = true
	player.DummyFriction = true;
	player.ForceCameraUpdate = false;
	enableMovement()
end
