#define DECLARE_TEXTURE(Name, index) \
    texture Name: register(t##index); \
    sampler Name##Sampler: register(s##index)

#define SAMPLE_TEXTURE(Name, texCoord) tex2D(Name##Sampler, texCoord)

uniform float Time; // level.TimeActive
uniform float2 CamPos; // level.Camera.Position
uniform float2 Dimensions; // new Vector2(320, 180)

uniform float4x4 TransformMatrix;
uniform float4x4 ViewMatrix;

DECLARE_TEXTURE(text, 0);

float4 SpritePixelShader(float2 uv : TEXCOORD0) : COLOR0
{
    float2 worldPos = (uv * Dimensions) + CamPos;

    float2 size = float2(0.02,0.04);

    float3 colorA = SAMPLE_TEXTURE(text, float2(uv.x - (sin(Time * 3) * size.x),uv.y - (cos(Time * 3) * size.y))).rgb;
    float3 colorB = SAMPLE_TEXTURE(text, float2(uv.x + (sin(Time * 3) * size.x),uv.y + (cos(Time * 3) * size.y))).rgb;

    float3 color = lerp(colorA,colorB,0.5);

    return float4(color,1.0);
}

void SpriteVertexShader(inout float4 color    : COLOR0,
                        inout float2 texCoord : TEXCOORD0,
                        inout float4 position : SV_Position)
{
    position = mul(position, ViewMatrix);
    position = mul(position, TransformMatrix);
}

technique Shader
{
    pass pass0
    {
        VertexShader = compile vs_3_0 SpriteVertexShader();
        PixelShader = compile ps_3_0 SpritePixelShader();
    }
}