#define DECLARE_TEXTURE(Name, index) \
    texture Name: register(t##index); \
    sampler Name##Sampler: register(s##index)

#define SAMPLE_TEXTURE(Name, texCoord) tex2D(Name##Sampler, texCoord)

uniform float Time; // level.TimeActive
uniform float2 CamPos; // level.Camera.Position
uniform float2 Dimensions; // new Vector2(320, 180)

uniform float4x4 TransformMatrix;
uniform float4x4 ViewMatrix;

DECLARE_TEXTURE(text, 0);

float rand(float2 co) {
    return frac(sin(dot(co.xy, float2(12.9898, 78.233))) * 43758.5453);
}
float noise(float2 p){
    float n = dot(p, float2(127.1, 311.7));
    return frac(sin(n) * 43758.5453);
}

float smoothNoise(float2 p){
    float2 i = floor(p);
    float2 f = frac(p);
    float2 u = f * f * (3.0 - 2.0 * f);

    float n00 = noise(i);
    float n10 = noise(i + float2(1.0, 0.0));
    float n01 = noise(i + float2(0.0, 1.0));
    float n11 = noise(i + float2(1.0, 1.0));

    float x1 = lerp(n00, n10, u.x);
    float x2 = lerp(n01, n11, u.x);
    return lerp(x1, x2, u.y);
}

float fbm(float2 p){
    float total = 0.0;
    float amplitude = 0.5;
    float frequency = 1.0;

    [unroll]
    for (int i = 0; i < 3; i++)
    {
        total += amplitude * smoothNoise(p * frequency);
        frequency *= 2.0;
        amplitude *= 0.5;
    }

    return total;
}

float4 SpritePixelShader(float2 uv : TEXCOORD0) : COLOR0
{
    float2 worldPos = (uv * Dimensions) + (CamPos / 2);
    float3 color = SAMPLE_TEXTURE(text, uv);
    float3 initial = color;
    float brightness = (color.r + color.g + color.b) / 3;

    color = lerp(color,float3(brightness,brightness,brightness),0.95);
    color *= brightness;
    color += abs(uv.y - 0.5) / 3;

    float waterfx = fbm(worldPos / 30);
    if(waterfx > 0.4 && waterfx < 0.5){
        color += 0.03;
    }
    float rand32 = rand(floor(worldPos / 64) * floor(Time));
    if (rand32 > 0.964){
        float3 init = color;
        color.r = rand(color.rg);
        color.g = rand(color.gb);
        color.b = rand(color.br);
        color = lerp(init,color,rand(floor(worldPos / 2)));
    }

    if (rand32 > 0.96){
        color = 1 - color;
    }
    float rand8 = rand(floor(worldPos / 8) * floor(Time));
    if (rand8 > 0.964){
        color = 1 - color;
    }
    if (rand8 < 0.003 && rand32 < 0.003){
        color = initial;
    }

    return float4(color,1.0);
}

void SpriteVertexShader(inout float4 color    : COLOR0,
                        inout float2 texCoord : TEXCOORD0,
                        inout float4 position : SV_Position)
{
    position = mul(position, ViewMatrix);
    position = mul(position, TransformMatrix);
}

technique Shader
{
    pass pass0
    {
        VertexShader = compile vs_3_0 SpriteVertexShader();
        PixelShader = compile ps_3_0 SpritePixelShader();
    }
}