-- Code from microlith and bit
local vector2 = require("#microsoft.xna.framework.vector2")
local monocle = require("#monocle")
local cor = monocle.Entity()

local function summonSeheniel(position)
    seheniel = celeste.NPC(position)
    getRoom():Add(seheniel)
    local sprite = celeste.GFX.SpriteBank:Create("seheniel")
    seheniel:Add(sprite)
    seheniel.Sprite = sprite
    sprite:Play("idle")
    seheniel.IdleAnim = "idle"
    seheniel.MoveAnim = "walk"
    seheniel.Maxspeed = 58
    seheniel.MoveY = true
end

local function moveSeheniel(xVector,yVector)
  coroutine.yield(seheniel:MoveTo(seheniel.Position + vector2(xVector, yVector)))
end

function onBegin()
if not (getFlag("seh2")) then
  disableMovement()
  disablePause()
  summonSeheniel(vector2(3192, -744))
  enablePause()
  moveSeheniel(0, -200)
  local level = getLevel()
  -- Zoom to 40 pixels below the center of the screen
  coroutine.yield(level:ZoomTo(vector2(160, 90), 1.05, 0.5))
  --player.DummyAutoAnimate = false
  say("WatchersMountain_Seheniel_2A")
 coroutine.yield(level:ZoomAcross(vector2(160, 90), 1, 0.5))
 setFlag("seh2", true)
 enableMovement()
 seheniel.Maxspeed = 10000
 moveSeheniel(0, -400)
 end
end


function onEnd(room, wasSkipped)
  setFlag("seh2", true)
  seheniel.Visible = false
  enableMovement()
end