local mods = require("mods")
local logging = require("logging")
local themes = {
    latte = mods.requireFromPlugin("libraries.latte"),
    frappe = mods.requireFromPlugin("libraries.frappe"),
    macchiato = mods.requireFromPlugin("libraries.macchiato"),
    green = mods.requireFromPlugin("libraries.macchiato"),
    mocha = mods.requireFromPlugin("libraries.mocha")
}

local function hueToRgb(p, q, T)
    local t = T
    if t < 0 then t = t + 1 end
    if t > 1 then t = t - 1 end
    if t < 1/6 then return p + (q - p) * 6 * t end
    if t < 1/2 then return q end
    if t < 2/3 then return p + (q - p) * (2/3 - t) * 6 end
    return p
end

local function hslToRgb(H, s, l)
    local r, g, b
    local h = H / 255
    if s == 0 then
        r = l
        g = l
        b = l
    else
        local q
        if l < 0.5 then q = l * (1 + s) else q = l + s - l * s end
        local p = 2 * l - q
        r = hueToRgb(p, q, h + 1/3)
        g = hueToRgb(p, q, h)
        b = hueToRgb(p, q, h - 1/3)
    end

    return {math.floor(r  * 255), math.floor(g  * 255), math.floor(b  * 255)}
end




local palettes = {}

palettes.getTheme = function(themeName)

    local palette = themes[themeName]


    palette.color = function (name, alpha)

        if themeName == "green" then
            
            
            local hsl = palette[name].hsl
            local rgb = hslToRgb(hsl[1] - 150, hsl[2], hsl[3])
            local color = {rgb[1] / 255, rgb[2] / 255, rgb[3] / 255, alpha}

            return color

        end

        local color = {}
        color[1] = palette[name].rgb[1] / 255
        color[2] = palette[name].rgb[2] / 255
        color[3] = palette[name].rgb[3] / 255
        color[4] = alpha
        return color
    end

    

    local theme = {
        __themeName = palette.name,
        horizontalLine = {
            color = palette.color("surface0", 1)
        },
        button = {
            disabledBG = palette.color("mantle", 0.7),
            disabledBorder = palette.color("surface0", 1),
            disabledFG = palette.color("subtext0", 0.7),
            hoveredBG = palette.color("surface1", 0.9),
            hoveredBorder = palette.color("surface1", 1),
            hoveredFG = palette.color("text", 1),
            normalBG = palette.color("surface0", 0.9),
            normalBorder = palette.color("surface1", 1),
            normalFG = palette.color("text", 1),
            pressedBG = palette.color("surface2", 0.9),
            pressedBorder = palette.color("surface2", 1),
            pressedFG = palette.color("text", 1)
        },
        buttonClose = {
            hoveredBG = palette.color("maroon", 1),
            normalBG = palette.color("maroon", 0.7),
            pressedBG = palette.color("maroon", 0.5)
        },
        buttonGreen = {
            hoveredBG = {0.7, 0.9, 0.7, 0.9},
            normalBG = {0.5, 0.8, 0.5, 0.8},
            pressedBG = {0.5, 0.9, 0.5, 0.9}
        },
        default = {},
        dropdown = {},
        field = {
            disabledBG = palette.color("surface0", 0.7),
            disabledBorder = palette.color("surface0", 1),
            disabledFG = palette.color("subtext0", 1),
            focusedBG = palette.color("surface2", 0.7),
            focusedBorder = palette.color("surface2", 1),
            focusedFG = palette.color("text", 1),
            normalBG = palette.color("surface1", 0.7),
            normalBorder = palette.color("surface1", 1),
            normalFG = palette.color("text", 1)
        },
        group = {
            bg = {},
            border = {},
            radius = 0
        },
        icon = {
            color = {0, 0, 0, 1}
        },
        image = {1, 1, 1, 1},
        label = {
            color = palette.color("text", 1)
        },
        list = {
            dragLineColor = {0.2, 0.2, 0.2, 1.0}
        },
        listItem = {
            disabledBG = palette.color("mantle", 0.7),
            disabledBorder = palette.color("surface0", 0.7),
            disabledFG = palette.color("subtext0", 1),
            hoveredBG = palette.color("surface1", 0.9),
            hoveredBorder = palette.color("surface1", 0.7),
            hoveredFG = palette.color("text", 1),
            normalBG = palette.color("surface0", 0.9),
            normalBorder = palette.color("surface1", 0.7),
            normalFG = palette.color("text", 1),
            pressedBG = palette.color("surface2", 0.9),
            pressedBorder = palette.color("surface2", 0.7),
            pressedFG = palette.color("text", 1),
            radius = 3,
            selectedBG = palette.color("blue", 1),
            selectedBorder = {0, 0, 0, 0, 1},
            selectedFG = palette.color("crust", 1)
        },
        listItemGreen = {
            hoveredBG = {0.7, 0.9, 0.7, 0.9},
            normalBG = {0.5, 0.8, 0.5, 0.8},
            pressedBG = {0.1, 0.6, 0.1, 0.9},
            selectedBG = {0.2, 0.7, 0.2, 0.9}
        },
        listItemYellow = {
            hoveredBG = {0.9, 0.8, 0.4, 0.9},
            normalBG = {0.8, 0.7, 0.3, 0.8},
            pressedBG = {0.3, 0.2, 0, 0.9},
            selectedBG = {0.4, 0.3, 0.1, 0.9}
        },
        menuItem = {
            bg = palette.color("crust", 0.8)
        },
        menuItemSubmenu = {
            bg = palette.color("crust", 0.8)
        },
        panel = {
            bg = palette.color("crust", 0.9),
            border = {0, 0, 0, 0},
            radius = 3
        },
        scrollbox = {},
        scrollhandle = {
            border = {},
            color = {},
            hoveredBorder = {0.6, 0.6, 0.6, 0.7, 1},
            hoveredColor = {0.6, 0.6, 0.6, 1},
            normalBorder = {0.5, 0.5, 0.5, 1, 1},
            normalColor = {0.5, 0.5, 0.5, 0.6},
            pressedBorder = {0.55, 0.55, 0.55, 0.7, 1},
            pressedColor = {0.55, 0.55, 0.55, 1},
            radius = 3,
            thickness = 6
        },
        scrollhandleX = {},
        scrollhandleY = {},
        spinner = {
            color = {0, 0, 0, 1}
        },
        titlebar = {
            border = {0, 0, 0, 0},
            focusedBG = palette.color("mantle", 1),
            focusedFG = palette.color("text", 1),
            radius = 0,
            unfocusedBG = palette.color("mantle", 1),
            unfocusedFG = palette.color("subtext0", 0.7)
        },
        topbar = {
            bg = palette.color("crust", 0.8),
            radius = 0
        },
        window = {
            bg = palette.color("crust", 1),
            border = palette.color("crust", 1)
        },
        LMAOindex = 0
    }

    local bg = palette.color("base", 1)

    local metatable = {
        __index = function(t, key)
            love.graphics.setBackgroundColor(bg[1], bg[2], bg[3], bg[4])
            return rawget(t, key)
        end
    }

    if themeName == "green" then
        theme.__themeName = "Evil Green Catppuccin"
    end

    setmetatable(theme, metatable)

    return theme
end

return palettes