local atlases = require("atlases")
local drawableSprite = require("structs.drawable_sprite")

local decal = {}

decal.name = "AdamsAddons/FlagChangeDecal"
decal.depth = 9000
decal.nodeLimits = {1, 1}
decal.nodeLineRenderType = "line"
decal.placements = {
    name = "decal",
    data = {
        textureFrom = "10-farewell/finalflag00",
        textureTo = "",
        flag = "",
        duration = 1.0,
        easing = "CubeOut",
        alphaFrom = 1.0,
        alphaTo = 1.0,
        depthFrom = 9000,
        depthTo = 9000,
        scaleXFrom = 1.0,
        scaleXTo = 1.0,
        scaleYFrom = 1.0,
        scaleYTo = 1.0,
        rotationFrom = 0.0,
        rotationTo = 0.0,
        tintFrom = "FFFFFF",
        tintTo = "FFFFFF",
        animationSpeed = 12.0,
        animationSpeedTo = 12.0
    }
}

local depths = {
    {"BG Terrain (10000)", 10000},
    {"BG Mirrors (9500)", 9500},
    {"BG Decals (9000)", 9000},
    {"BG Particles (8000)", 8000},
    {"Solids Below (5000)", 5000},
    {"Below (2000)", 2000},
    {"NPCs (1000)", 1000},
    {"Theo Crystal (100)", 100},
    {"Player (0)", 0},
    {"Dust (-50)", -50},
    {"Pickups (-100)", -100},
    {"Seeker (-200)", -200},
    {"Particles (-8000)", -8000},
    {"Above (-8500)", -8500},
    {"Solids (-9000)", -9000},
    {"FG Terrain (-10000)", -10000},
    {"FG Decals (-10500)", -10500},
    {"Dream Blocks (-11000)", -11000},
    {"Crystal Spinners (-11500)", -11500},
    {"Player Dreamdashing (-12000)", -12000},
    {"Enemy (-12500)", -12500},
    {"Fake Walls (-13000)", -13000},
    {"FG Particles (-50000)", -50000},
    {"Top (-1000000)", -1000000},
    {"Formation Sequences (-2000000)", -2000000},
}
local easeTypes = { "Linear", "SineIn", "SineOut", "SineInOut", "QuadIn", "QuadOut", "QuadInOut", "CubeIn", "CubeOut", "CubeInOut", "QuintIn", "QuintOut", "QuintInOut", "BackIn", "BackOut", "BackInOut", "ExpoIn", "ExpoOut", "ExpoInOut", "BigBackIn", "BigBackOut", "BigBackInOut", "ElasticIn", "ElasticOut", "ElasticInOut", "BounceIn", "BounceOut", "BounceInOut" }

decal.fieldInformation = {
    depthFrom = {
        fieldType = "integer",
        options = depths
    },
    depthTo = {
        fieldType = "integer",
        options = depths
    },
    easing = {
        options = easeTypes,
        editable = false
    },
    alphaFrom = {
        fieldType = "number",
        minimumValue = 0.0,
        maximumValue = 1.0
    },
    alphaTo = {
        fieldType = "number",
        minimumValue = 0.0,
        maximumValue = 1.0
    },
    duration = {
        fieldType = "number",
        minimumValue = 0.0
    },
    tintFrom = {
        fieldType = "color"
    },
    tintTo = {
        fieldType = "color"
    }
}

decal.fieldOrder = {"x","y","textureFrom","textureTo","animationSpeed","animationSpeedTo","duration","easing","scaleXFrom","scaleXTo","scaleYFrom","scaleYTo","rotationFrom","rotationTo","tintFrom","tintTo","alphaFrom","alphaTo","depthFrom","depthTo","flag"}

function decal.texture(room, entity)
    if atlases.gameplay["decals/" .. entity.textureFrom] then
        return "decals/" .. entity.textureFrom
    end
    return "decals/Anzen/AdamsAddons/fallback"
end

function decal.nodeTexture(room, entity)
    if entity.textureTo == "" then
        if atlases.gameplay["decals/" .. entity.textureFrom] then
            return "decals/" .. entity.textureFrom
        end
    elseif atlases.gameplay["decals/" .. entity.textureTo] then
        return "decals/" .. entity.textureTo
    end
    return "decals/Anzen/AdamsAddons/fallback"
end

function decal.scale(room, entity)
    return { entity.scaleXFrom or 1, entity.scaleYFrom or 1 }
end

function decal.rotation(room, entity)
    return (entity.rotationFrom or 0) * math.pi / 180
end

function decal.nodeScale(room, entity)
    return { entity.scaleXTo or 1, entity.scaleYTo or 1 }
end

function decal.nodeRotation(room, entity)
    return (entity.rotationTo or 0) * math.pi / 180
end

return decal