local drawableSprite = require("structs.drawable_sprite")
local drawableRectangle = require("structs.drawable_rectangle")

local lonnBarrier = {}

lonnBarrier.name = "AdamsAddons/LonnBarrier"
lonnBarrier.depth = -12000
lonnBarrier.canResize = {true, true}
lonnBarrier.placements = {
    name = "barrier",
    alternativeName = "barrier_alt",
    data = {
        width = 8,
        height = 8
    }
}


function lonnBarrier.sprite(room, entity)
    local x, y = entity.x or 0, entity.y or 0
    local width, height = entity.width or 8, entity.height or 8

    local sprites = {}

    for tx = 0, math.floor(width / 8) - 1 do
        for ty = 0, math.floor(height / 8) - 1 do
            local sprite
            if (tx + ty) % 2 == 0 then
                sprite = drawableSprite.fromTexture("objects/lonnBarrier/Anzen/AdamsAddons/tile")
            else
                sprite = drawableSprite.fromTexture("objects/lonnBarrier/Anzen/AdamsAddons/tile_alt")
            end
            sprite:addPosition(x + tx * 8 + 4, y + ty * 8 + 4)
            table.insert(sprites, sprite)
        end
    end

    table.insert(sprites, drawableRectangle.fromRectangle("bordered", utils.rectangle(entity.x,entity.y,entity.width,entity.height), {0,0,0,0}, {1,1,1,1}))

    return sprites
end

return lonnBarrier