local drawableSprite = require("structs.drawable_sprite")
local atlases = require("atlases")

local PSFC = {}

PSFC.name = "AdamsAddons/PlayerSpriteFlagController"
PSFC.depth = -1000000
PSFC.placements = {
    name = "controller",
    data = {
        spritePath = "idle00",
        folderPath = "characters/player/",
        flag = "sprite_idle"
    }
}

PSFC.fieldOrder = {
    "x","y","folderPath","spritePath","flag"
}

function PSFC.sprite(room, entity)
    local controller_texture = "objects/Anzen/AdamsAddons/PlayerSpriteFlagController/icon"
    local player_texture = "characters/" .. entity.spritePath
    if entity.folderPath ~= nil then
        player_texture = entity.folderPath .. entity.spritePath
    end

    if atlases.gameplay[player_texture .. "00"]  then 
        player_texture = player_texture .. "00" 
    end
    if not atlases.gameplay[player_texture] then
        player_texture = "decals/Anzen/AdamsAddons/fallback"
    end

    local MainSprite = drawableSprite.fromTexture(controller_texture, entity)
    local PlayerSprite = drawableSprite.fromTexture(player_texture, entity)

    if player_texture ~= "decals/Anzen/AdamsAddons/fallback" then PlayerSprite:addPosition(0, -9) end

    local sprites = {
        MainSprite,
        PlayerSprite
    }
    return sprites
end

return PSFC