local atlases = require("atlases")

local refill = {}

refill.name = "AdamsAddons/PortalDashRefill"
refill.depth = -100
refill.placements = {
    {
        name = "portal_refill",
        data = {
            oneUse = false,
            preserveState = false,
            sprite = "Anzen/AdamsAddons/",
            particleColor = "be4cff",
            particleColor2 = "7800bd",
            exitSpeed = 240,
            distance = 36
        }
    }--[[,
    {
        name = "portal_refill_alt",
        data = {
            oneUse = false,
            preserveState = true,
            sprite = "Anzen/AdamsAddons/",
            particleColor = "c4e0ff",
            particleColor2 = "76b8ff",
            exitSpeed = 240,
            teleportDistance = 36
        }
    }]]
}

refill.fieldInformation = {
    particleColor = {
        fieldType = "color",
        allowEmpty = true
    },
    particleColor2 = {
        fieldType = "color",
        allowEmpty = true
    }
}

function refill.ignoredFields(entity)
    local ignored = {
        "_id",
        "_name",
        "preserveState"
    }

    if entity.preserveState then
        table.insert(ignored, "exitSpeed")
    end

    return ignored
end

refill.fieldOrder = {"x", "y", "distance", "exitSpeed", "particleColor", "particleColor2", "sprite", "oneUse"}

function refill.texture(room, entity)
    if entity.preserveState then
        if atlases.gameplay["objects/portalDashRefillAlt/" .. entity.sprite .. "idle00"] then
            return ("objects/portalDashRefillAlt/" .. entity.sprite .. "idle00")
        end
        return "objects/portalDashRefillAlt/Anzen/AdamsAddons/idle00"
    else
        if atlases.gameplay["objects/portalDashRefill/" .. entity.sprite .. "idle00"] then
            return ("objects/portalDashRefill/" .. entity.sprite .. "idle00")
        end
        return "objects/portalDashRefill/Anzen/AdamsAddons/idle00"
    end
end

return refill